/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.frames;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import org.pdfsam.guiclient.GuiClient;
import org.pdfsam.guiclient.business.TextPaneAppender;
import org.pdfsam.guiclient.business.listeners.mediators.ApplicationExitMediator;
import org.pdfsam.guiclient.gui.panels.JBackgroundedPanel;

public class JSplashScreen
extends JFrame {
    private static final long serialVersionUID = 3664676940782142274L;
    private final JLabel labelProgress = new JLabel();
    private final JLabel labelVersion = new JLabel();
    private final JProgressBar progressBar = new JProgressBar();
    private final JBackgroundedPanel topPanel = new JBackgroundedPanel("/images/splashscreen.png");
    private final JPanel bottomPanel = new JPanel();
    private final JButton exitButton = new JButton();
    private final JScrollPane logPane = new JScrollPane();
    private String initMessage;

    public JSplashScreen(String title, String initMessage) {
        this.setTitle(title);
        this.initMessage = initMessage;
        this.init();
    }

    private void init() {
        this.setUndecorated(true);
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.topPanel.setBorder(new EtchedBorder(1));
        this.progressBar.setBorderPainted(true);
        this.progressBar.setOrientation(0);
        this.progressBar.setValue(0);
        this.progressBar.setAlignmentX(0.0f);
        this.labelProgress.setFont(new Font("SansSerif", 0, 10));
        this.labelProgress.setPreferredSize(new Dimension(350, 15));
        this.labelProgress.setText(this.initMessage);
        this.labelProgress.setAlignmentX(0.0f);
        this.labelVersion.setText("pdfsam " + GuiClient.getVersion());
        this.labelVersion.setPreferredSize(new Dimension(350, 15));
        this.labelVersion.setFont(new Font("SansSerif", 1, 10));
        this.labelVersion.setAlignmentY(1.0f);
        this.labelVersion.setAlignmentX(0.0f);
        this.topPanel.add(this.labelProgress);
        this.topPanel.add(this.progressBar);
        this.topPanel.add(Box.createVerticalGlue());
        this.topPanel.add(this.labelVersion);
        this.topPanel.setOpaque(false);
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 2));
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.bottomPanel.setBorder(new EtchedBorder(1));
        this.exitButton.setText("Exit");
        this.exitButton.setActionCommand("exit");
        this.exitButton.addActionListener(new ApplicationExitMediator());
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.bottomPanel.add(this.exitButton);
        this.logPane.setViewportView(TextPaneAppender.getTextPaneInstance());
        this.logPane.setPreferredSize(new Dimension(350, 65));
        this.getContentPane().add((Component)this.topPanel, "First");
        this.getContentPane().add((Component)this.bottomPanel, "Last");
        this.getContentPane().add((Component)this.logPane, "Center");
        this.center(this, 350, 200);
    }

    private void center(JFrame frame, int width, int height) {
        Dimension framedimension = new Dimension(width, height);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        Double centreX = new Double(screensize.getWidth() / 2.0 - framedimension.getWidth() / 2.0);
        Double centreY = new Double(screensize.getHeight() / 2.0 - framedimension.getHeight() / 2.0);
        frame.setBounds(centreX.intValue(), centreY.intValue(), width, height);
    }

    public void setText(String message) {
        if (this.labelProgress != null) {
            this.labelProgress.setText(message);
        }
    }

    public void addBarValue() {
        if (this.progressBar != null) {
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        }
    }

    public void setMaximumBarValue(int value) {
        if (this.progressBar != null) {
            this.progressBar.setMaximum(value);
        }
    }
}

