/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.writer;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectProxy;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.cos.ICOSProxyVisitor;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class COSWriter
implements ICOSObjectVisitor,
ICOSProxyVisitor {
    public static final byte[] ARRAY_CLOSE = "]".getBytes();
    public static final byte[] ARRAY_OPEN = "[".getBytes();
    public static final byte[] COMMENT = "%".getBytes();
    public static final byte[] CRLF = "\r\n".getBytes();
    public static final byte[] DICT_CLOSE = ">>".getBytes();
    public static final byte[] DICT_OPEN = "<<".getBytes();
    protected static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '9'};
    public static final byte[] ENDOBJ = "endobj".getBytes();
    public static final byte[] ENDSTREAM = "endstream".getBytes();
    public static final byte[] EOF = "%%EOF".getBytes();
    public static final byte[] EOL = System.getProperty("line.separator").getBytes();
    public static final byte[] FALSE = "false".getBytes();
    public static final byte[] GARBAGE = "\u00f6\u00e4\u00fc\u00df".getBytes();
    public static final byte[] LF = "\n".getBytes();
    public static final byte[] LITERAL_ESCAPED_BS = "\\b".getBytes();
    public static final byte[] LITERAL_ESCAPED_CR = "\\r".getBytes();
    public static final byte[] LITERAL_ESCAPED_FF = "\\f".getBytes();
    public static final byte[] LITERAL_ESCAPED_HT = "\\t".getBytes();
    public static final byte[] LITERAL_ESCAPED_LF = "\\n".getBytes();
    public static final byte[] NAME_ESCAPE = "#".getBytes();
    public static final byte[] NAME_PREFIX = "/".getBytes();
    public static final byte[] NULL = "null".getBytes();
    public static final byte[] OBJ = "obj".getBytes();
    public static final byte[] PDF_ESCAPE = "\\".getBytes();
    public static final byte[] REFERENCE = "R".getBytes();
    public static final byte[] SPACE = " ".getBytes();
    public static final byte[] STREAM = "stream".getBytes();
    public static final byte[] STRING_CLOSE = ")".getBytes();
    public static final byte[] STRING_HEX_CLOSE = ">".getBytes();
    public static final byte[] STRING_HEX_OPEN = "<".getBytes();
    public static final byte[] STRING_OPEN = "(".getBytes();
    public static final byte[] TRAILER = "trailer".getBytes();
    public static final byte[] TRUE = "true".getBytes();
    private COSIndirectObject currentObject;
    private ISystemSecurityHandler securityHandler;
    private boolean incremental = true;
    private boolean onNewLine = false;
    private List proxies = new ArrayList();
    private IRandomAccess randomAccess;

    public static void basicWriteFixed(IRandomAccess iRandomAccess, float f, int n) throws IOException {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setGroupingUsed(false);
        iRandomAccess.write(StringTools.toByteArray((String)numberFormat.format(f)));
    }

    public static void basicWriteInteger(IRandomAccess iRandomAccess, int n) throws IOException {
        iRandomAccess.write(StringTools.toByteArray((String)Integer.toString(n)));
    }

    public static void basicWriteName(IRandomAccess iRandomAccess, byte[] byArray) throws IOException {
        iRandomAccess.write(NAME_PREFIX);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 <= 32 || n2 >= 127 || PDFParser.isDelimiter(n2) || n2 == 35) {
                iRandomAccess.write(NAME_ESCAPE);
                iRandomAccess.write(HexTools.ByteToHex[n2]);
            } else {
                iRandomAccess.write(n2);
            }
            ++n;
        }
    }

    public static void basicWriteStringHex(IRandomAccess iRandomAccess, byte[] byArray) throws IOException {
        iRandomAccess.write(STRING_HEX_OPEN);
        int n = 0;
        while (n < byArray.length) {
            iRandomAccess.write(HexTools.ByteToHex[byArray[n] & 0xFF]);
            ++n;
        }
        iRandomAccess.write(STRING_HEX_CLOSE);
    }

    public static void basicWriteStringLiteral(IRandomAccess iRandomAccess, byte[] byArray) throws IOException {
        iRandomAccess.write(STRING_OPEN);
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            if (by == 10) {
                iRandomAccess.write(LITERAL_ESCAPED_LF);
            } else if (by == 13) {
                iRandomAccess.write(LITERAL_ESCAPED_CR);
            } else if (by == 9) {
                iRandomAccess.write(LITERAL_ESCAPED_HT);
            } else if (by == 12) {
                iRandomAccess.write(LITERAL_ESCAPED_FF);
            } else if (by == 8) {
                iRandomAccess.write(LITERAL_ESCAPED_BS);
            } else if (by == 40 || by == 41 || by == 92) {
                iRandomAccess.write(PDF_ESCAPE);
                iRandomAccess.write((int)by);
            } else {
                iRandomAccess.write((int)by);
            }
            ++n;
        }
        iRandomAccess.write(STRING_CLOSE);
    }

    public static final byte[] toByteArray(COSObject cOSObject) {
        RandomAccessByteArray randomAccessByteArray = new RandomAccessByteArray(null);
        COSWriter cOSWriter = new COSWriter((IRandomAccess)randomAccessByteArray, null);
        try {
            cOSWriter.writeObject(cOSObject);
        }
        catch (IOException iOException) {
            return "*** not printable ***".getBytes();
        }
        return randomAccessByteArray.toByteArray();
    }

    public COSWriter(IRandomAccess iRandomAccess, ISystemSecurityHandler iSystemSecurityHandler) {
        this.securityHandler = iSystemSecurityHandler;
        this.randomAccess = iRandomAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicWriteDocument(STDocument sTDocument) throws IOException {
        if (sTDocument.isDirty()) {
            sTDocument.updateModificationDate();
            sTDocument.getTrailer().updateFileID();
        }
        if (sTDocument.isNew()) {
            this.setIncremental(false);
        }
        if (sTDocument.isClosed()) {
            return;
        }
        if (!this.isIncremental()) {
            sTDocument.garbageCollect();
        } else {
            sTDocument.incrementalGarbageCollect();
        }
        Object object = sTDocument.getAccessLock();
        synchronized (object) {
            Collection<COSIndirectObject> collection;
            if (!this.isIncremental()) {
                this.getRandomAccess().setLength(0L);
                this.writeHeader(sTDocument);
            }
            if ((collection = sTDocument.getChanges()).size() > 0) {
                this.seekToEnd();
                STXRefSection sTXRefSection = sTDocument.createNewXRefSection();
                if (this.getSecurityHandler() != null) {
                    this.getSecurityHandler().updateTrailer(sTXRefSection.cosGetDict());
                }
                for (COSIndirectObject cOSIndirectObject : collection) {
                    this.writeEntry(sTXRefSection, cOSIndirectObject);
                    cOSIndirectObject.setDirty(false);
                }
                this.seekToEnd();
                this.writeXRef(sTXRefSection);
                this.writeEOF();
                sTDocument.setXRefSection(sTXRefSection);
                sTDocument.setDirty(false);
            }
            for (Object object2 : this.getProxies()) {
                ((COSObjectProxy)object2).ended(this);
            }
            this.getRandomAccess().flush();
        }
    }

    protected void close(STDocument sTDocument) throws IOException {
    }

    protected byte[] encryptStream(COSDictionary cOSDictionary, byte[] byArray) throws IOException {
        if (this.getSecurityHandler() != null && this.getCurrentObject() != null) {
            try {
                return this.getSecurityHandler().encryptStream(this.getCurrentObject().getKey(), cOSDictionary, byArray);
            }
            catch (COSSecurityException cOSSecurityException) {
                IOException iOException = new IOException("error encrypting data");
                iOException.initCause(cOSSecurityException);
                throw iOException;
            }
        }
        return byArray;
    }

    protected byte[] encryptString(COSString cOSString) throws IOException {
        byte[] byArray = cOSString.byteValue();
        if (this.getSecurityHandler() != null && this.getCurrentObject() != null) {
            try {
                return this.getSecurityHandler().encryptString(this.getCurrentObject().getKey(), byArray);
            }
            catch (COSSecurityException cOSSecurityException) {
                IOException iOException = new IOException("error encrypting data");
                iOException.initCause(cOSSecurityException);
                throw iOException;
            }
        }
        return byArray;
    }

    protected COSIndirectObject getCurrentObject() {
        return this.currentObject;
    }

    public List getProxies() {
        return this.proxies;
    }

    public IRandomAccess getRandomAccess() {
        return this.randomAccess;
    }

    protected ISystemSecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    protected boolean isOnNewLine() {
        return this.onNewLine;
    }

    protected void reset() {
        this.onNewLine = false;
    }

    public void seekToEnd() throws IOException {
        this.randomAccess.seek(this.randomAccess.getLength());
        this.reset();
    }

    protected void setCurrentObject(COSIndirectObject cOSIndirectObject) {
        this.currentObject = cOSIndirectObject;
    }

    public void setIncremental(boolean bl) {
        this.incremental = bl;
    }

    @Override
    public Object visitFromArray(COSArray cOSArray) throws COSVisitorException {
        try {
            try {
                if (this.getSecurityHandler() != null) {
                    this.getSecurityHandler().pushContextObject(cOSArray);
                }
                int n = 0;
                this.write(ARRAY_OPEN);
                Iterator iterator = cOSArray.basicIterator();
                while (iterator.hasNext()) {
                    COSDocumentElement cOSDocumentElement = (COSDocumentElement)iterator.next();
                    cOSDocumentElement.accept(this);
                    ++n;
                    if (!iterator.hasNext()) continue;
                    if (n % 10 == 0) {
                        this.writeEOL();
                        continue;
                    }
                    this.write(SPACE);
                }
                this.write(ARRAY_CLOSE);
                this.writeEOL();
            }
            catch (IOException iOException) {
                throw new COSVisitorException(iOException);
            }
        }
        finally {
            if (this.getSecurityHandler() != null) {
                this.getSecurityHandler().popContextObject();
            }
        }
        return null;
    }

    @Override
    public Object visitFromBoolean(COSBoolean cOSBoolean) throws COSVisitorException {
        try {
            if (cOSBoolean.booleanValue()) {
                this.write(TRUE);
            } else {
                this.write(FALSE);
            }
        }
        catch (IOException iOException) {
            throw new COSVisitorException(iOException);
        }
        return null;
    }

    @Override
    public Object visitFromDictionary(COSDictionary cOSDictionary) throws COSVisitorException {
        try {
            try {
                if (this.getSecurityHandler() != null) {
                    this.getSecurityHandler().pushContextObject(cOSDictionary);
                }
                this.write(DICT_OPEN);
                this.writeEOL();
                Iterator iterator = cOSDictionary.basicEntryIterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    COSName cOSName = (COSName)entry.getKey();
                    COSDocumentElement cOSDocumentElement = (COSDocumentElement)entry.getValue();
                    if (cOSDocumentElement == null) continue;
                    COSWriter.basicWriteName(this.randomAccess, cOSName.byteValue());
                    this.write(SPACE);
                    cOSDocumentElement.accept(this);
                    this.writeEOL();
                }
                this.write(DICT_CLOSE);
                this.writeEOL();
            }
            catch (IOException iOException) {
                throw new COSVisitorException(iOException);
            }
        }
        finally {
            if (this.getSecurityHandler() != null) {
                this.getSecurityHandler().popContextObject();
            }
        }
        return null;
    }

    @Override
    public Object visitFromFixed(COSFixed cOSFixed) throws COSVisitorException {
        try {
            COSWriter.basicWriteFixed(this.randomAccess, cOSFixed.floatValue(), cOSFixed.getPrecision());
            this.onNewLine = false;
        }
        catch (IOException iOException) {
            throw new COSVisitorException(iOException);
        }
        return null;
    }

    @Override
    public Object visitFromIndirectObject(COSIndirectObject cOSIndirectObject) throws COSVisitorException {
        this.reset();
        try {
            this.write(StringTools.toByteArray((String)Integer.toString(cOSIndirectObject.getObjectNumber())));
            this.write(SPACE);
            this.write(StringTools.toByteArray((String)Integer.toString(cOSIndirectObject.getGenerationNumber())));
            this.write(SPACE);
            this.write(REFERENCE);
        }
        catch (IOException iOException) {
            throw new COSVisitorException(iOException);
        }
        return null;
    }

    @Override
    public Object visitFromInteger(COSInteger cOSInteger) throws COSVisitorException {
        try {
            COSWriter.basicWriteInteger(this.randomAccess, cOSInteger.intValue());
            this.onNewLine = false;
        }
        catch (IOException iOException) {
            throw new COSVisitorException(iOException);
        }
        return null;
    }

    @Override
    public Object visitFromName(COSName cOSName) throws COSVisitorException {
        try {
            COSWriter.basicWriteName(this.randomAccess, cOSName.byteValue());
            this.onNewLine = false;
        }
        catch (IOException iOException) {
            throw new COSVisitorException(iOException);
        }
        return null;
    }

    @Override
    public Object visitFromNull(COSNull cOSNull) throws COSVisitorException {
        try {
            this.write(NULL);
        }
        catch (IOException iOException) {
            throw new COSVisitorException(iOException);
        }
        return null;
    }

    @Override
    public Object visitFromProxy(COSObjectProxy cOSObjectProxy) throws COSVisitorException {
        try {
            cOSObjectProxy.setPosition(this.getRandomAccess().getOffset());
            this.randomAccess.seekBy((long)cOSObjectProxy.getLength());
        }
        catch (IOException iOException) {
            throw new COSVisitorException(iOException);
        }
        this.proxies.add(cOSObjectProxy);
        return null;
    }

    @Override
    public Object visitFromStream(COSStream cOSStream) throws COSVisitorException {
        try {
            try {
                byte[] byArray;
                if (this.getSecurityHandler() != null) {
                    this.getSecurityHandler().pushContextObject(cOSStream);
                }
                byte[] byArray2 = new byte[]{};
                if (!cOSStream.isExternal()) {
                    byArray2 = cOSStream.getEncodedBytes();
                }
                int n = (byArray = this.encryptStream(cOSStream.getDict(), byArray2)) == null ? 0 : byArray.length;
                cOSStream.getDict().basicPutSilent(COSStream.DK_Length, COSInteger.create(n));
                cOSStream.getDict().accept(this);
                n = byArray2 == null ? 0 : byArray2.length;
                cOSStream.getDict().basicPutSilent(COSStream.DK_Length, COSInteger.create(n));
                this.writeCRLF();
                this.writeStreamContent(byArray);
            }
            catch (IOException iOException) {
                throw new COSVisitorException(iOException);
            }
        }
        finally {
            if (this.getSecurityHandler() != null) {
                this.getSecurityHandler().popContextObject();
            }
        }
        return null;
    }

    @Override
    public Object visitFromString(COSString cOSString) throws COSVisitorException {
        try {
            if (cOSString.isHexMode()) {
                this.writeStringHex(this.encryptString(cOSString));
            } else {
                this.writeStringLiteral(this.encryptString(cOSString));
            }
            this.onNewLine = false;
        }
        catch (IOException iOException) {
            throw new COSVisitorException(iOException);
        }
        return null;
    }

    public void write(byte[] byArray) throws IOException {
        this.onNewLine = false;
        this.randomAccess.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.onNewLine = false;
        this.randomAccess.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.onNewLine = false;
        this.randomAccess.write(n);
    }

    public void writeContentStream(CSContent cSContent) throws IOException {
        int n = cSContent.size();
        int n2 = 0;
        while (n2 < n) {
            CSOperation cSOperation = cSContent.getOperation(n2);
            try {
                this.writeOperation(cSOperation);
            }
            catch (COSVisitorException cOSVisitorException) {
                IOException iOException = new IOException(cOSVisitorException.getMessage());
                iOException.initCause(cOSVisitorException);
                throw iOException;
            }
            this.write(32);
            ++n2;
        }
    }

    protected void writeCRLF() throws IOException {
        this.randomAccess.write(CRLF);
    }

    public void writeDocument(STDocument sTDocument) throws IOException {
        this.basicWriteDocument(sTDocument);
        this.close(sTDocument);
    }

    protected void writeEntry(STXRefSection sTXRefSection, COSIndirectObject cOSIndirectObject) throws IOException {
        STXRefEntryOccupied sTXRefEntryOccupied = new STXRefEntryOccupied(cOSIndirectObject.getObjectNumber(), cOSIndirectObject.getGenerationNumber(), this.getRandomAccess().getOffset());
        sTXRefSection.addEntry(sTXRefEntryOccupied);
        this.writeIndirectObject(cOSIndirectObject);
    }

    protected void writeEOF() throws IOException {
        this.write(EOF);
        this.writeEOL();
    }

    public void writeEOL() throws IOException {
        if (!this.isOnNewLine()) {
            this.randomAccess.write(EOL);
            this.onNewLine = true;
        }
    }

    protected void writeHeader(STDocument sTDocument) throws IOException {
        this.write(COMMENT);
        this.write(sTDocument.getVersion().getBytes());
        this.writeEOL();
        this.write(COMMENT);
        this.write(GARBAGE);
        this.writeEOL();
    }

    protected void writeImageData(COSObject cOSObject) throws IOException {
        if (cOSObject instanceof COSString) {
            this.randomAccess.write(((COSString)cOSObject).byteValue());
        } else if (cOSObject instanceof COSStream) {
            this.randomAccess.write(((COSStream)cOSObject).getDecodedBytes());
        } else if (cOSObject instanceof COSName) {
            this.randomAccess.write(((COSName)cOSObject).byteValue());
        }
        this.randomAccess.write(10);
    }

    public void writeIndirectObject(COSIndirectObject cOSIndirectObject) throws IOException {
        this.setCurrentObject(cOSIndirectObject);
        this.reset();
        this.write(StringTools.toByteArray((String)Integer.toString(cOSIndirectObject.getObjectNumber())));
        this.write(SPACE);
        this.write(StringTools.toByteArray((String)Integer.toString(cOSIndirectObject.getGenerationNumber())));
        this.write(SPACE);
        this.write(OBJ);
        this.writeEOL();
        try {
            cOSIndirectObject.dereference().accept(this);
        }
        catch (COSVisitorException cOSVisitorException) {
            Throwable throwable = cOSVisitorException.getCause() == null ? cOSVisitorException : cOSVisitorException.getCause();
            IOException iOException = new IOException(throwable.getMessage());
            iOException.initCause(cOSVisitorException);
            throw iOException;
        }
        this.writeEOL();
        this.write(ENDOBJ);
        this.writeEOL();
        this.setCurrentObject(null);
    }

    public void writeObject(COSObject cOSObject) throws IOException {
        try {
            cOSObject.accept(this);
        }
        catch (COSVisitorException cOSVisitorException) {
            IOException iOException = new IOException(cOSVisitorException.getMessage());
            iOException.initCause(cOSVisitorException);
            throw iOException;
        }
    }

    protected void writeOperation(CSOperation cSOperation) throws COSVisitorException, IOException {
        if (cSOperation.matchesOperator(CSOperators.CSO_EI) && cSOperation.operandSize() == 1) {
            this.writeImageData(cSOperation.getOperand(0));
        } else {
            Iterator iterator = cSOperation.getOperands();
            while (iterator.hasNext()) {
                COSObject cOSObject = (COSObject)iterator.next();
                cOSObject.accept(this);
                this.write(32);
            }
        }
        this.write(cSOperation.getOperatorToken());
    }

    protected void writeStreamContent(byte[] byArray) throws IOException {
        this.write(STREAM);
        this.writeCRLF();
        if (byArray != null) {
            this.write(byArray);
        }
        this.writeCRLF();
        this.write(ENDSTREAM);
        this.writeEOL();
    }

    protected void writeStringHex(byte[] byArray) throws IOException {
        COSWriter.basicWriteStringHex(this.randomAccess, byArray);
    }

    protected void writeStringLiteral(byte[] byArray) throws IOException {
        COSWriter.basicWriteStringLiteral(this.randomAccess, byArray);
    }

    protected void writeXRef(STXRefSection sTXRefSection) throws IOException {
        AbstractXRefWriter abstractXRefWriter = sTXRefSection.getWriter(this);
        abstractXRefWriter.writeXRef(sTXRefSection);
    }
}

