/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.reporter.IReporter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultReporter
implements IReporter {
    private final Logger logger;

    public DefaultReporter() {
        this(LogTools.getLogger(DefaultReporter.class));
    }

    public DefaultReporter(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public void reportActivityEnd() {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, "end activity ");
        }
    }

    @Override
    public void reportActivityStart(String string, int n) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, "start activity " + string);
        }
    }

    @Override
    public void reportError(String string, String string2, Throwable throwable, int n) {
        this.getLogger().log(Level.SEVERE, string2, throwable);
    }

    @Override
    public void reportMessage(String string, String string2, int n) {
        this.getLogger().log(Level.INFO, string2);
    }

    @Override
    public void reportProgress(String string, int n, int n2) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, String.valueOf(string) + " [" + n + "%]");
        }
    }

    @Override
    public void reportStatus(String string, int n) {
        this.getLogger().log(Level.INFO, string);
    }
}

