/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction.file;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.transaction.CommonResource;
import de.intarsys.tools.transaction.ResourceException;
import de.intarsys.tools.transaction.file.FileSystemResourceType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileSystemResource
extends CommonResource {
    private List<IFunctor> rollbackActions = new ArrayList<IFunctor>();

    protected FileSystemResource(FileSystemResourceType fileSystemResourceType, FileSystemResource fileSystemResource) {
        super(fileSystemResourceType, fileSystemResource);
    }

    @Override
    public void commit() throws ResourceException {
        this.rollbackActions.clear();
    }

    public void onRollback(IFunctor iFunctor) {
        if (!this.isActive()) {
            return;
        }
        this.rollbackActions.add(iFunctor);
    }

    public void onRollbackDelete(final File file) {
        if (file == null || !this.isActive()) {
            return;
        }
        this.onRollback(new IFunctor(){

            public Object perform(IFunctorCall iFunctorCall) throws FunctorInvocationException {
                file.delete();
                return null;
            }
        });
    }

    public void onRollbackMove(final File file, final File file2) {
        if (file == null || file2 == null || file.equals(file2) || !this.isActive()) {
            return;
        }
        this.onRollback(new IFunctor(){

            public Object perform(IFunctorCall iFunctorCall) throws FunctorInvocationException {
                try {
                    FileTools.copyFile(file, file2);
                }
                catch (IOException iOException) {
                    throw new FunctorInvocationException(iOException);
                }
                file.delete();
                return null;
            }
        });
    }

    @Override
    public void rollback() throws ResourceException {
        ArrayList<IFunctor> arrayList = new ArrayList<IFunctor>(this.rollbackActions);
        Collections.reverse(arrayList);
        for (IFunctor iFunctor : arrayList) {
            FunctorCall functorCall = new FunctorCall(this, Args.create());
            try {
                iFunctor.perform(functorCall);
            }
            catch (FunctorInvocationException functorInvocationException) {
                throw new ResourceException(functorInvocationException);
            }
        }
        this.rollbackActions.clear();
    }
}

