/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.emp4j.exceptions;

import org.pdfsam.emp4j.providers.ExceptionMessageProvider;

public class ParentEmp4jException
extends Exception {
    private static final long serialVersionUID = 1665312932892362305L;
    protected String errorMessage;
    protected String localizedErrorMessage;

    public ParentEmp4jException() {
    }

    public ParentEmp4jException(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ParentEmp4jException(Throwable t) {
        super(t);
    }

    public ParentEmp4jException(String errorMessage, Throwable t) {
        super(t);
        this.errorMessage = errorMessage;
    }

    public ParentEmp4jException(Object exceptionKeyCode, int exceptionErrorCode, Throwable e) {
        this(exceptionKeyCode, exceptionErrorCode, null, e);
    }

    public ParentEmp4jException(Object exceptionKeyCode, int exceptionErrorCode, String[] args, Throwable e) {
        super(e);
        this.errorMessage = this.getExceptionMessage(exceptionKeyCode, exceptionErrorCode, args);
        this.localizedErrorMessage = this.getLocalizedExceptionMessage(exceptionKeyCode, exceptionErrorCode, args);
    }

    public ParentEmp4jException(Object exceptionKeyCode, int exceptionErrorCode) {
        this(exceptionKeyCode, exceptionErrorCode, new String[0]);
    }

    public ParentEmp4jException(Object exceptionKeyCode, int exceptionErrorCode, String[] args) {
        this.errorMessage = this.getExceptionMessage(exceptionKeyCode, exceptionErrorCode, args);
        this.localizedErrorMessage = this.getLocalizedExceptionMessage(exceptionKeyCode, exceptionErrorCode, args);
    }

    protected String getExceptionMessage(Object exceptionTypeKey, int exceptionErrorCode, String[] args) {
        String retVal = "";
        try {
            ExceptionMessageProvider emp = ExceptionMessageProvider.getInstance();
            retVal = emp != null ? ExceptionMessageProvider.getInstance().getExceptionMessage(exceptionTypeKey, exceptionErrorCode, args) : "ExceptionMessageProvider is null: exceptionTypeKey=" + exceptionTypeKey.toString() + " exceptionErrorCode=" + exceptionErrorCode;
        }
        catch (Exception ex) {
            retVal = "Unable to get Exception message [" + ex.getMessage() + "] exceptionTypeKey=" + exceptionTypeKey.toString() + " exceptionErrorCode=" + exceptionErrorCode;
        }
        return retVal;
    }

    protected String getLocalizedExceptionMessage(Object exceptionTypeKey, int exceptionErrorCode, String[] args) {
        String retVal = "";
        try {
            ExceptionMessageProvider emp = ExceptionMessageProvider.getInstance();
            retVal = emp != null ? ExceptionMessageProvider.getInstance().getLocalizedExceptionMessage(exceptionTypeKey, exceptionErrorCode, args) : "ExceptionMessageProvider is null: exceptionTypeKey=" + exceptionTypeKey.toString() + " exceptionErrorCode=" + exceptionErrorCode;
        }
        catch (Exception ex) {
            retVal = "Unable to get Localized Exception message [" + ex.getMessage() + "] exceptionTypeKey=" + exceptionTypeKey.toString() + " exceptionErrorCode=" + exceptionErrorCode;
        }
        return retVal;
    }

    public String getMessage() {
        return this.errorMessage;
    }

    public String getLocalizedMessage() {
        return this.localizedErrorMessage;
    }
}

