/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.deployment.ExtensionRemovedException;
import com.sun.star.deployment.XPackage;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XTruncate;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.framework.container.DeployedUnoPackagesDB;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.container.ParsedScriptUri;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.io.XInputStreamWrapper;
import com.sun.star.script.framework.io.XOutputStreamWrapper;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class UnoPkgContainer
extends ParcelContainer {
    private final Map<String, ParcelContainer> registeredPackages = new HashMap<String, ParcelContainer>();
    private final String extensionDb;
    private final String extensionRepository;

    public UnoPkgContainer(XComponentContext xComponentContext, String string, String string2, String string3, String string4) throws IllegalArgumentException, WrappedTargetException {
        super(xComponentContext, string, string4, false);
        this.extensionDb = string2;
        this.extensionRepository = string3;
        this.init();
    }

    public ParcelContainer getRegisteredUnoPkgContainer(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        LogUtils.DEBUG("** getRegisterPackage ctx = " + this.containerUrl);
        LogUtils.DEBUG("** getRegisterPackage  for uri " + string);
        LogUtils.DEBUG("** getRegisterPackage  for langugage " + this.language);
        ParcelContainer parcelContainer = this.registeredPackages.get(string);
        LogUtils.DEBUG("getRegisterPackage result is  " + parcelContainer);
        return parcelContainer;
    }

    public boolean hasRegisteredUnoPkgContainer(String string) {
        return this.getRegisteredUnoPkgContainer(string) != null;
    }

    private void registerPackageContainer(String string, ParcelContainer parcelContainer) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        LogUtils.DEBUG("RegisterPackage ctx = " + this.containerUrl);
        LogUtils.DEBUG("RegisterPackage language = " + this.language);
        LogUtils.DEBUG("RegisterPackage " + parcelContainer + " for url " + string);
        this.registeredPackages.put(string, parcelContainer);
    }

    public void deRegisterPackageContainer(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        LogUtils.DEBUG("In deRegisterPackageContainer for " + string);
        if (this.hasRegisteredUnoPkgContainer(string)) {
            try {
                DeployedUnoPackagesDB deployedUnoPackagesDB = this.getUnoPackagesDB();
                if (deployedUnoPackagesDB != null && deployedUnoPackagesDB.removePackage(this.language, string)) {
                    this.writeUnoPackageDB(deployedUnoPackagesDB);
                    ParcelContainer parcelContainer = this.registeredPackages.get(string);
                    if (!parcelContainer.hasElements() && parcelContainer.parent() != null) {
                        parcelContainer.parent().removeChildContainer(parcelContainer);
                    }
                    this.registeredPackages.remove(string);
                }
            }
            catch (Exception exception) {
                LogUtils.DEBUG("***** deRegisterPackageContainer() got exception " + exception);
            }
        }
        LogUtils.DEBUG("Leaving deRegisterPackageContainer for " + string);
    }

    private void init() throws IllegalArgumentException {
        LogUtils.DEBUG("getting container for  " + this.containerUrl);
        try {
            DeployedUnoPackagesDB deployedUnoPackagesDB = this.getUnoPackagesDB();
            if (deployedUnoPackagesDB != null) {
                String[] stringArray;
                for (String string : stringArray = deployedUnoPackagesDB.getDeployedPackages(this.language)) {
                    try {
                        this.processUnoPackage(string, this.language);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LogUtils.DEBUG("Failed to process " + string + " for " + this.language);
                        LogUtils.DEBUG("   Reason: " + (Object)((Object)illegalArgumentException));
                    }
                    catch (Exception exception) {
                        LogUtils.DEBUG("Something very wrong!!!!!");
                        LogUtils.DEBUG("Failed to process " + string + " for " + this.language);
                        LogUtils.DEBUG("   Reason: " + exception);
                    }
                }
            }
        }
        catch (WrappedTargetException wrappedTargetException) {
            LogUtils.DEBUG("No deployed uno-packages for " + this.containerUrl);
        }
    }

    public ScriptMetaData findScript(ParsedScriptUri parsedScriptUri) throws NoSuchElementException, WrappedTargetException {
        Object var2_2 = null;
        String string = parsedScriptUri.function;
        String string2 = parsedScriptUri.parcel;
        String string3 = parsedScriptUri.location;
        LogUtils.DEBUG("*** UnoPkgContainer.findScript() ***\ncontainerUrl = " + this.containerUrl + "\nfunction = " + string + "\nlocation = " + string3 + "\nparcel = " + string2);
        ParcelContainer parcelContainer = this.getChildContainer(string3);
        if (parcelContainer == null) {
            throw new WrappedTargetException("Failed to resolve script ", null, (Object)new IllegalArgumentException("Cannot resolve script location for script = " + string));
        }
        return parcelContainer.findScript(parsedScriptUri);
    }

    private DeployedUnoPackagesDB getUnoPackagesDB() throws WrappedTargetException {
        InputStream inputStream = null;
        DeployedUnoPackagesDB deployedUnoPackagesDB = null;
        try {
            String string = PathUtils.make_url(this.extensionDb, "/Scripts/" + this.extensionRepository + "-extension-desc.xml");
            LogUtils.DEBUG("getUnoPackagesDB() looking for existing db in " + string);
            if (m_xSFA.exists(string)) {
                if (string.startsWith("vnd.sun.star.tdoc")) {
                    throw new WrappedTargetException("Can't handle documents yet");
                }
                inputStream = new XInputStreamWrapper(m_xSFA.openFileRead(string));
                deployedUnoPackagesDB = new DeployedUnoPackagesDB(inputStream);
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (Exception exception) {}
            } else {
                LogUtils.DEBUG("getUnoPackagesDB() " + string + " does not exist");
            }
        }
        catch (Exception exception) {
            LogUtils.DEBUG("getUnoPackagesDB() caught Exception: " + exception);
            LogUtils.DEBUG(LogUtils.getTrace(exception));
            throw new WrappedTargetException((Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (Exception exception) {}
            }
        }
        return deployedUnoPackagesDB;
    }

    private void writeUnoPackageDB(DeployedUnoPackagesDB deployedUnoPackagesDB) throws IllegalArgumentException, WrappedTargetException {
        LogUtils.DEBUG("In writeUnoPackageDB() ");
        XOutputStream xOutputStream = null;
        OutputStream outputStream = null;
        try {
            String string = PathUtils.make_url(this.extensionDb, "/Scripts/" + this.extensionRepository + "-extension-desc.xml");
            xOutputStream = m_xSFA.openFileWrite(string);
            XTruncate xTruncate = (XTruncate)UnoRuntime.queryInterface(XTruncate.class, (Object)xOutputStream);
            if (xTruncate != null) {
                LogUtils.DEBUG("In writeUnoPackageDB() Truncating....");
                xTruncate.truncate();
            } else {
                LogUtils.DEBUG("In writeUnoPackageDB() CAN'T Truncate....");
            }
            outputStream = new XOutputStreamWrapper(xOutputStream);
            deployedUnoPackagesDB.write(outputStream);
            try {
                outputStream.close();
                outputStream = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            LogUtils.DEBUG("In writeUnoPackageDB() Exception: " + exception);
            throw new WrappedTargetException((Throwable)exception);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                    outputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void processUnoPackage(XPackage xPackage, String string) throws IllegalArgumentException, WrappedTargetException, ElementExistException {
        LogUtils.DEBUG("** in processUnoPackage ");
        String string2 = xPackage.getURL();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        LogUtils.DEBUG("** processUnoPackage getURL() -> " + string2);
        LogUtils.DEBUG("** processUnoPackage getName() -> " + xPackage.getName());
        LogUtils.DEBUG("** processUnoPackage getMediaType() -> " + xPackage.getPackageType().getMediaType());
        try {
            LogUtils.DEBUG("** processUnoPackage getDisplayName() -> " + xPackage.getDisplayName());
        }
        catch (ExtensionRemovedException extensionRemovedException) {
            throw new WrappedTargetException(extensionRemovedException.getMessage(), (Object)this, (Object)extensionRemovedException);
        }
        this.processUnoPackage(string2, string);
        DeployedUnoPackagesDB deployedUnoPackagesDB = this.getUnoPackagesDB();
        if (deployedUnoPackagesDB == null) {
            try {
                deployedUnoPackagesDB = new DeployedUnoPackagesDB();
            }
            catch (IOException iOException) {
                throw new WrappedTargetException((Throwable)iOException);
            }
        }
        deployedUnoPackagesDB.addPackage(string, string2);
        this.writeUnoPackageDB(deployedUnoPackagesDB);
    }

    private void processUnoPackage(String string, String string2) throws IllegalArgumentException, WrappedTargetException, ElementExistException {
        if (this.hasRegisteredUnoPkgContainer(string)) {
            throw new ElementExistException("Already a registered uno package " + string + " for language " + string2);
        }
        LogUtils.DEBUG("processUnoPackage - URL = " + string);
        LogUtils.DEBUG("processUnoPackage - script library package");
        String string3 = string;
        if (string.contains("%2Funo_packages%2F") || string.contains("/uno_packages/") || string.contains("$UNO_USER_PACKAGES_CACHE/") || string.contains("$UNO_SHARED_PACKAGES_CACHE/") || string.contains("$BUNDLED_EXTENSIONS/")) {
            ParcelContainer parcelContainer;
            LogUtils.DEBUG("processUnoPackage - is part of a uno bundle");
            int n = string.lastIndexOf(47);
            if (string.endsWith("/")) {
                string = string.substring(0, n);
                n = string.lastIndexOf(47);
            }
            if (n > -1) {
                string3 = string.substring(0, n);
                LogUtils.DEBUG("processUnoPackage - composition is contained in " + string3);
            }
            if ((parcelContainer = this.getChildContainerForURL(string3)) == null) {
                parcelContainer = new ParcelContainer(this, this.m_xCtx, string3, string2, false);
                if (parcelContainer.loadParcel(string) == null) {
                    throw new IllegalArgumentException("Couldn't load script library from composition package " + string + " for language " + string2);
                }
                this.addChildContainer(parcelContainer);
            } else if (parcelContainer.loadParcel(string) == null) {
                throw new IllegalArgumentException("Couldn't load script library from composition package " + string + " for language " + string2);
            }
            this.registerPackageContainer(string, parcelContainer);
        } else {
            if (this.loadParcel(string) == null) {
                throw new IllegalArgumentException("Couldn't load script library package " + string + " for language " + string2);
            }
            this.registerPackageContainer(string, this);
        }
    }
}

