<?php

/**
 * @file
 * Contains \Drupal\Core\Entity\EntityReferenceSelection\SelectionInterface.
 */

namespace Drupal\Core\Entity\EntityReferenceSelection;

use Drupal\Core\Database\Query\SelectInterface;
use Drupal\Core\Plugin\PluginFormInterface;

/**
 * Interface definition for Entity Reference Selection plugins.
 *
 * @see \Drupal\Core\Entity\EntityReferenceSelection\SelectionPluginManager
 * @see \Drupal\Core\Entity\Annotation\EntityReferenceSelection
 * @see plugin_api
 */
interface SelectionInterface extends PluginFormInterface {

  /**
   * Gets the list of referenceable entities.
   *
   * @return array
   *   A nested array of entities, the first level is keyed by the
   *   entity bundle, which contains an array of entity labels (escaped),
   *   keyed by the entity ID.
   */
  public function getReferenceableEntities($match = NULL, $match_operator = 'CONTAINS', $limit = 0);

  /**
   * Counts entities that are referenceable.
   *
   * @return int
   *   The number of referenceable entities.
   */
  public function countReferenceableEntities($match = NULL, $match_operator = 'CONTAINS');

  /**
   * Validates which existing entities can be referenced.
   *
   * @return array
   *   An array of valid entity IDs.
   */
  public function validateReferenceableEntities(array $ids);

  /**
   * Allows the selection to alter the SelectQuery generated by EntityFieldQuery.
   *
   * @param \Drupal\Core\Database\Query\SelectInterface $query
   *   A Select Query object.
   */
  public function entityQueryAlter(SelectInterface $query);

}
