<?php

/**
 * @file
 * Contains \Drupal\migrate_events_test\Plugin\migrate\destination\DummyDestination.
 */

namespace Drupal\migrate_events_test\Plugin\migrate\destination;

use Drupal\migrate\Entity\MigrationInterface;
use Drupal\migrate\Plugin\migrate\destination\DestinationBase;
use Drupal\migrate\Row;

/**
 * @MigrateDestination(
 *   id = "dummy",
 *   requirements_met = true
 * )
 */
class DummyDestination extends DestinationBase {

  /**
   * {@inheritdoc}
   */
  public function getIds() {
    $ids['value']['type'] = 'string';
    return $ids;
  }

  /**
   * {@inheritdoc}
   */
  public function fields(MigrationInterface $migration = NULL) {
    return ['value' => 'Dummy value'];
  }

  /**
   * {@inheritdoc}
   */
  public function import(Row $row, array $old_destination_id_values = array()) {
    return ['value' => $row->getDestinationProperty('value')];
  }

}
