/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Rubinius::AtomicReference")
public abstract class AtomicReferenceNodes {

    @CoreMethod(names={"get_and_set"}, required=1)
    public static abstract class GetAndSetNode
    extends CoreMethodArrayArgumentsNode {
        public GetAndSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getAndSet(DynamicObject self, Object value) {
            return Layouts.ATOMIC_REFERENCE.getAndSetValue(self, value);
        }
    }

    @CoreMethod(names={"compare_and_set"}, required=2)
    public static abstract class CompareAndSetNode
    extends CoreMethodArrayArgumentsNode {
        public CompareAndSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean compareAndSet(DynamicObject self, Object expected_value, Object value) {
            return Layouts.ATOMIC_REFERENCE.compareAndSetValue(self, expected_value, value);
        }
    }

    @CoreMethod(names={"set"}, required=1)
    public static abstract class SetNode
    extends CoreMethodArrayArgumentsNode {
        public SetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object set(DynamicObject self, Object value) {
            Layouts.ATOMIC_REFERENCE.setValue(self, value);
            return value;
        }
    }

    @CoreMethod(names={"get"})
    public static abstract class GetNode
    extends CoreMethodArrayArgumentsNode {
        public GetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object get(DynamicObject self) {
            return Layouts.ATOMIC_REFERENCE.getValue(self);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.ATOMIC_REFERENCE.createAtomicReference(Layouts.CLASS.getInstanceFactory(rubyClass), this.nil());
        }
    }
}

