/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.RubyArray;
import org.jruby.RubyProc;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class Block {
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    private final Binding binding;
    private final BlockBody body;
    private boolean escaped;
    private Block escapeBlock = this;
    public static final Block NULL_BLOCK = new Block(BlockBody.NULL_BODY);

    public Block(BlockBody body, Binding binding2) {
        this.body = body;
        this.binding = binding2;
    }

    public Block(BlockBody body) {
        this.body = body;
        this.binding = null;
    }

    public void setEvalType(EvalType evalType) {
        this.body.setEvalType(evalType);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.body.call(context, args2, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.body.call(context, args2, this.binding, this.type, block);
    }

    public IRubyObject call(ThreadContext context) {
        return this.body.call(context, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, Block block) {
        return this.body.call(context, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context) {
        return this.body.yieldSpecific(context, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0) {
        return this.body.call(context, arg0, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, Block block) {
        return this.body.call(context, arg0, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0) {
        return this.body.yieldSpecific(context, arg0, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.body.call(context, arg0, arg1, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.body.call(context, arg0, arg1, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.body.yieldSpecific(context, arg0, arg1, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.body.call(context, arg0, arg1, arg2, this.binding, this.type);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.body.call(context, arg0, arg1, arg2, this.binding, this.type, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.body.yieldSpecific(context, arg0, arg1, arg2, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2) {
        return this.body.yield(context, value2, this.binding, this.type);
    }

    public IRubyObject yieldNonArray(ThreadContext context, IRubyObject value2, IRubyObject self2) {
        return this.body.yield(context, new IRubyObject[]{value2}, self2, this.binding, this.type);
    }

    public IRubyObject yieldArray(ThreadContext context, IRubyObject value2, IRubyObject self2) {
        IRubyObject[] args2 = !(value2 instanceof RubyArray) ? new IRubyObject[]{value2} : value2.convertToArray().toJavaArray();
        return this.body.yield(context, args2, self2, this.binding, this.type);
    }

    public Block cloneBlock() {
        Block newBlock = new Block(this.body, this.binding);
        newBlock.type = this.type;
        newBlock.escapeBlock = this;
        return newBlock;
    }

    public Block cloneBlockAndFrame() {
        Binding oldBinding = this.binding;
        Binding binding2 = new Binding(oldBinding.getSelf(), oldBinding.getFrame().duplicate(), oldBinding.getVisibility(), oldBinding.getDynamicScope(), oldBinding.getMethod(), oldBinding.getFile(), oldBinding.getLine());
        Block newBlock = new Block(this.body, binding2);
        newBlock.type = this.type;
        newBlock.escapeBlock = this;
        return newBlock;
    }

    public Block cloneBlockForEval(IRubyObject self2, EvalType evalType) {
        Block block = this.cloneBlock();
        block.getBinding().setSelf(self2);
        block.getBinding().getFrame().setSelf(self2);
        block.setEvalType(evalType);
        return block;
    }

    @Deprecated
    public Arity arity() {
        return this.body.getSignature().arity();
    }

    public Signature getSignature() {
        return this.body.getSignature();
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public final boolean isGiven() {
        return this != NULL_BLOCK;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public Frame getFrame() {
        return this.binding.getFrame();
    }

    public boolean isEscaped() {
        return this.escapeBlock.escaped;
    }

    public void escape() {
        this.escapeBlock.escaped = true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Block)) {
            return false;
        }
        Block bOther = (Block)other;
        return this.binding.equals(bOther.binding) && this.body == bOther.body;
    }

    public static enum Type {
        NORMAL(false),
        PROC(false),
        LAMBDA(true),
        THREAD(false);

        public final boolean checkArity;

        private Type(boolean checkArity) {
            this.checkArity = checkArity;
        }
    }
}

