/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.tools.component.ISaveStateSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class COSObject
extends COSDocumentElement
implements ISaveStateSupport {
    public static final ICOSContainer CONSTANT_CONTAINER = new ICOSContainer(){

        @Override
        public ICOSContainer associate(ICOSContainer iCOSContainer, COSObject cOSObject) {
            throw new IllegalStateException("constants can not be contained");
        }

        @Override
        public COSDocumentElement containable(COSObject cOSObject) {
            return cOSObject.copyDeep().containable();
        }

        @Override
        public ICOSContainer disassociate(ICOSContainer iCOSContainer, COSObject cOSObject) {
            throw new IllegalStateException("constants can not be contained");
        }

        @Override
        public COSDocument getDoc() {
            return null;
        }

        @Override
        public void harden(COSObject cOSObject) {
        }

        @Override
        public int referenceCount() {
            return 0;
        }

        @Override
        public COSIndirectObject referenceIndirect(COSObject cOSObject) {
            throw new IllegalStateException("constants can not be indirect");
        }

        @Override
        public void register(COSDocumentElement cOSDocumentElement) {
        }

        @Override
        public ICOSContainer restoreStateContainer(ICOSContainer iCOSContainer) {
            return iCOSContainer;
        }

        @Override
        public ICOSContainer saveStateContainer() {
            return this;
        }

        @Override
        public void soften(COSObject cOSObject) {
        }

        @Override
        public void willChange(COSObject cOSObject) {
        }
    };
    public static final ICOSContainer NULL_CONTAINER = new ICOSContainer(){

        @Override
        public ICOSContainer associate(ICOSContainer iCOSContainer, COSObject cOSObject) {
            cOSObject.basicSetContainer(iCOSContainer);
            iCOSContainer.register(cOSObject);
            return iCOSContainer;
        }

        @Override
        public COSDocumentElement containable(COSObject cOSObject) {
            return cOSObject;
        }

        @Override
        public ICOSContainer disassociate(ICOSContainer iCOSContainer, COSObject cOSObject) {
            throw new IllegalStateException("association inconsistent");
        }

        @Override
        public COSDocument getDoc() {
            return null;
        }

        @Override
        public void harden(COSObject cOSObject) {
        }

        @Override
        public int referenceCount() {
            return 0;
        }

        @Override
        public COSIndirectObject referenceIndirect(COSObject cOSObject) {
            return COSIndirectObject.create(cOSObject);
        }

        @Override
        public void register(COSDocumentElement cOSDocumentElement) {
        }

        @Override
        public ICOSContainer restoreStateContainer(ICOSContainer iCOSContainer) {
            return iCOSContainer;
        }

        @Override
        public ICOSContainer saveStateContainer() {
            return this;
        }

        @Override
        public void soften(COSObject cOSObject) {
        }

        @Override
        public void willChange(COSObject cOSObject) {
        }
    };
    public static final Object SLOT_CONTAINER = new Object();
    protected ICOSContainer container = NULL_CONTAINER;

    protected COSObject() {
    }

    @Override
    protected ICOSContainer addContainer(ICOSContainer iCOSContainer) {
        return this.container.associate(iCOSContainer, this);
    }

    public abstract void addObjectListener(ICOSObjectListener var1);

    public COSArray asArray() {
        return null;
    }

    public COSBoolean asBoolean() {
        return null;
    }

    public COSDictionary asDictionary() {
        return null;
    }

    public COSFixed asFixed() {
        return null;
    }

    public COSInteger asInteger() {
        return null;
    }

    public COSName asName() {
        return null;
    }

    public COSNull asNull() {
        return null;
    }

    public COSNumber asNumber() {
        return null;
    }

    public COSStream asStream() {
        return null;
    }

    public COSString asString() {
        return null;
    }

    public abstract Iterator<COSDocumentElement> basicIterator();

    protected void basicSetContainer(ICOSContainer iCOSContainer) {
        this.container = iCOSContainer;
    }

    protected abstract String basicToString();

    public COSObject beConstant() {
        this.container = CONSTANT_CONTAINER;
        return this;
    }

    public COSIndirectObject beIndirect() {
        return this.container.referenceIndirect(this);
    }

    @Override
    public COSDocumentElement containable() {
        return this.container.containable(this);
    }

    protected abstract COSObject copyBasic();

    public abstract COSObject copyDeep();

    @Override
    public abstract COSObject copyDeep(Map var1);

    public final COSObject copyOptional() {
        if (this.isIndirect()) {
            return this;
        }
        return this.copyShallow();
    }

    public COSObject copyShallow() {
        COSObject cOSObject = this.copyBasic();
        if (this.isIndirect()) {
            cOSObject.beIndirect();
        }
        return cOSObject;
    }

    @Override
    protected COSDocumentElement copyShallowNested() {
        return this.copyShallow();
    }

    public final COSObject copySubGraph() {
        return this.copySubGraph(new HashMap());
    }

    protected COSObject copySubGraph(Map map) {
        COSObject cOSObject = this.copyBasic();
        if (this.isIndirect()) {
            cOSObject.beIndirect();
            map.put(this.getIndirectObject(), cOSObject);
        }
        return cOSObject;
    }

    @Override
    public COSObject dereference() {
        return this;
    }

    public ICOSContainer getContainer() {
        return this.container;
    }

    @Override
    public COSDocument getDoc() {
        return this.container.getDoc();
    }

    public COSIndirectObject getIndirectObject() {
        if (this.container instanceof COSIndirectObject) {
            return (COSIndirectObject)this.container;
        }
        return null;
    }

    public boolean getValueBoolean(boolean bl) {
        COSBoolean cOSBoolean = this.asBoolean();
        if (cOSBoolean == null) {
            return bl;
        }
        return cOSBoolean.booleanValue();
    }

    public byte[] getValueBytes(byte[] byArray) {
        COSObject cOSObject = this.asString();
        if (cOSObject != null) {
            return cOSObject.byteValue();
        }
        cOSObject = this.asName();
        if (cOSObject != null) {
            return ((COSName)cOSObject).byteValue();
        }
        cOSObject = this.asStream();
        if (cOSObject != null) {
            return ((COSStream)cOSObject).getDecodedBytes();
        }
        return byArray;
    }

    public float getValueFloat(float f) {
        COSNumber cOSNumber = this.asNumber();
        if (cOSNumber == null) {
            return f;
        }
        return cOSNumber.floatValue();
    }

    public int getValueInteger(int n) {
        COSNumber cOSNumber = this.asNumber();
        if (cOSNumber == null) {
            return n;
        }
        return cOSNumber.intValue();
    }

    public String getValueString(String string) {
        COSObject cOSObject = this.asString();
        if (cOSObject != null) {
            return cOSObject.stringValue();
        }
        cOSObject = this.asName();
        if (cOSObject != null) {
            return cOSObject.stringValue();
        }
        cOSObject = this.asStream();
        if (cOSObject != null) {
            return cOSObject.stringValue();
        }
        return string;
    }

    public void harden() {
        this.container.harden(this);
    }

    protected boolean hasNavigationPathTo(COSObject cOSObject) {
        return false;
    }

    public boolean isDangling() {
        return this.container.referenceCount() == 0;
    }

    public boolean isIndirect() {
        return this.container instanceof COSIndirectObject;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public abstract boolean isObjectListenerAvailable();

    public abstract boolean isPrimitive();

    @Override
    public boolean isSwapped() {
        return this.isIndirect() && this.getIndirectObject().isSwapped();
    }

    public abstract Iterator iterator();

    public boolean mayBeSwapped() {
        return false;
    }

    @Override
    protected ICOSContainer removeContainer(ICOSContainer iCOSContainer) {
        return this.container.disassociate(iCOSContainer, this);
    }

    public abstract void removeObjectListener(ICOSObjectListener var1);

    public void restoreState(Object object) {
        this.container = this.container.restoreStateContainer(((COSObject)object).container);
    }

    public void soften() {
        this.container.soften(this);
    }

    public String stringValue() {
        return this.basicToString();
    }

    public String toString() {
        return this.basicToString();
    }

    protected abstract void triggerChanged(Object var1, Object var2, Object var3);
}

