/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser;

import jcmdline.CmdLineHandler;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.parser.handlers.ConcatCmdHandler;
import org.pdfsam.console.business.parser.handlers.DecryptCmdHandler;
import org.pdfsam.console.business.parser.handlers.DefaultCmdHandler;
import org.pdfsam.console.business.parser.handlers.DocumentInfoCmdHandler;
import org.pdfsam.console.business.parser.handlers.EncryptCmdHandler;
import org.pdfsam.console.business.parser.handlers.MixCmdHandler;
import org.pdfsam.console.business.parser.handlers.PageLabelsCmdHandler;
import org.pdfsam.console.business.parser.handlers.RotateCmdHandler;
import org.pdfsam.console.business.parser.handlers.SetViewerCmdHandler;
import org.pdfsam.console.business.parser.handlers.SlideShowCmdHandler;
import org.pdfsam.console.business.parser.handlers.SplitCmdHandler;
import org.pdfsam.console.business.parser.handlers.UnpackCmdHandler;
import org.pdfsam.console.business.parser.handlers.interfaces.CmdHandler;
import org.pdfsam.console.business.parser.validators.ConcatCmdValidator;
import org.pdfsam.console.business.parser.validators.DecryptCmdValidator;
import org.pdfsam.console.business.parser.validators.DocumentInfoCmdValidator;
import org.pdfsam.console.business.parser.validators.EncryptCmdValidator;
import org.pdfsam.console.business.parser.validators.MixCmdValidator;
import org.pdfsam.console.business.parser.validators.PageLabelsCmdValidator;
import org.pdfsam.console.business.parser.validators.RotateCmdValidator;
import org.pdfsam.console.business.parser.validators.SetViewerCmdValidator;
import org.pdfsam.console.business.parser.validators.SlideShowCmdValidator;
import org.pdfsam.console.business.parser.validators.SplitCmdValidator;
import org.pdfsam.console.business.parser.validators.UnpackCmdValidator;
import org.pdfsam.console.business.parser.validators.interfaces.CmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;

public class CmdParseManager {
    private final Logger log = Logger.getLogger(CmdParseManager.class.getPackage().getName());
    private String[] inputArguments;
    private CmdHandler cmdHandler;
    private CmdValidator cmdValidator;
    private final StopWatch stopWatch = new StopWatch();

    public CmdParseManager() {
        this.setInputArguments(null);
    }

    public CmdParseManager(String[] inputArguments) {
        this.setInputArguments(inputArguments);
    }

    private String getInputCommand() {
        String retVal = this.inputArguments != null && this.inputArguments.length > 0 ? this.inputArguments[this.inputArguments.length - 1] : "";
        return retVal;
    }

    public void setInputArguments(String[] inputArguments) {
        this.inputArguments = inputArguments;
        String inputCommand = this.getInputCommand();
        if ("mix".equals(inputCommand)) {
            this.cmdHandler = new MixCmdHandler();
            this.cmdValidator = new MixCmdValidator();
        } else if ("concat".equals(inputCommand)) {
            this.cmdHandler = new ConcatCmdHandler();
            this.cmdValidator = new ConcatCmdValidator();
        } else if ("split".equals(inputCommand)) {
            this.cmdHandler = new SplitCmdHandler();
            this.cmdValidator = new SplitCmdValidator();
        } else if ("encrypt".equals(inputCommand)) {
            this.cmdHandler = new EncryptCmdHandler();
            this.cmdValidator = new EncryptCmdValidator();
        } else if ("unpack".equals(inputCommand)) {
            this.cmdHandler = new UnpackCmdHandler();
            this.cmdValidator = new UnpackCmdValidator();
        } else if ("setviewer".equals(inputCommand)) {
            this.cmdHandler = new SetViewerCmdHandler();
            this.cmdValidator = new SetViewerCmdValidator();
        } else if ("slideshow".equals(inputCommand)) {
            this.cmdHandler = new SlideShowCmdHandler();
            this.cmdValidator = new SlideShowCmdValidator();
        } else if ("decrypt".equals(inputCommand)) {
            this.cmdHandler = new DecryptCmdHandler();
            this.cmdValidator = new DecryptCmdValidator();
        } else if ("rotate".equals(inputCommand)) {
            this.cmdHandler = new RotateCmdHandler();
            this.cmdValidator = new RotateCmdValidator();
        } else if ("pagelabels".equals(inputCommand)) {
            this.cmdHandler = new PageLabelsCmdHandler();
            this.cmdValidator = new PageLabelsCmdValidator();
        } else if ("setdocinfo".equals(inputCommand)) {
            this.cmdHandler = new DocumentInfoCmdHandler();
            this.cmdValidator = new DocumentInfoCmdValidator();
        } else {
            this.cmdHandler = new DefaultCmdHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse() throws ConsoleException {
        boolean retVal;
        block6: {
            this.stopWatch.reset();
            this.stopWatch.start();
            retVal = false;
            try {
                if (this.cmdHandler != null) {
                    CmdLineHandler cmdLineHandler = this.cmdHandler.getCommandLineHandler();
                    this.log.debug("Starting arguments parsing.");
                    if (cmdLineHandler != null) {
                        retVal = cmdLineHandler.parse(this.inputArguments);
                        if (!retVal) {
                            throw new ParseException(1, new String[]{cmdLineHandler.getParseError()});
                        }
                        break block6;
                    }
                    throw new ConsoleException(2);
                }
                throw new ConsoleException(2);
            }
            finally {
                this.stopWatch.stop();
                this.log.debug("Command '" + this.getInputCommand() + "' parsed in " + DurationFormatUtils.formatDurationWords((long)this.stopWatch.getTime(), (boolean)true, (boolean)true));
            }
        }
        return retVal;
    }

    public boolean parse(String[] inputArguments) throws ConsoleException {
        this.setInputArguments(inputArguments);
        return this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractParsedCommand validate() throws ConsoleException {
        AbstractParsedCommand retVal;
        block6: {
            this.stopWatch.reset();
            this.stopWatch.start();
            retVal = null;
            try {
                if (this.cmdHandler != null) {
                    CmdLineHandler cmdLineHandler = this.cmdHandler.getCommandLineHandler();
                    this.log.debug("Starting arguments validation.");
                    if (cmdLineHandler != null) {
                        if (this.cmdValidator != null) {
                            retVal = this.cmdValidator.validate(cmdLineHandler);
                            break block6;
                        }
                        throw new ConsoleException(4);
                    }
                    throw new ConsoleException(2);
                }
                throw new ConsoleException(2);
            }
            finally {
                this.stopWatch.stop();
                this.log.debug("Command '" + this.getInputCommand() + "' validated in " + DurationFormatUtils.formatDurationWords((long)this.stopWatch.getTime(), (boolean)true, (boolean)true));
            }
        }
        return retVal;
    }
}

