/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.writers;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopyFields;
import com.lowagie.text.pdf.PdfReader;
import java.io.OutputStream;
import java.util.List;
import org.pdfsam.console.business.pdf.writers.interfaces.PdfConcatenator;

public class PdfCopyFieldsConcatenator
implements PdfConcatenator {
    private PdfCopyFields writer;

    public PdfCopyFieldsConcatenator(OutputStream os) throws DocumentException {
        this.writer = new PdfCopyFields(os);
    }

    public PdfCopyFieldsConcatenator(OutputStream os, boolean compressed) throws DocumentException {
        this(os);
        if (compressed) {
            this.writer.setFullCompression();
            this.writer.getWriter().setCompressionLevel(9);
        }
    }

    public void addDocument(PdfReader reader, String ranges) throws Exception {
        if (reader == null) {
            throw new DocumentException("Reader is null");
        }
        reader.selectPages(ranges);
        this.writer.addDocument(reader);
    }

    public void addDocument(PdfReader reader) throws Exception {
        if (reader == null) {
            throw new DocumentException("Reader is null");
        }
        this.writer.addDocument(reader);
    }

    public void freeReader(PdfReader reader) throws Exception {
        this.writer.getWriter().freeReader(reader);
    }

    public void setOutlines(List outlines) {
        this.writer.setOutlines(outlines);
    }

    public void setPdfVersion(char pdfVersion) {
        this.writer.getWriter().setPdfVersion(pdfVersion);
    }

    public void close() {
        this.writer.close();
    }
}

