/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.converter;

import de.intarsys.tools.converter.Canonical;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.converter.Undefined;
import java.util.HashMap;
import java.util.Map;

public class DoubleDispatchConverter
implements IConverter<Object, Object> {
    private final Map<Class, IConverter> converters = new HashMap<Class, IConverter>();
    private final Class targetType;

    public DoubleDispatchConverter(Class clazz) {
        this.targetType = clazz;
    }

    @Override
    public Object convert(Object object) throws ConversionException {
        IConverter<?, ?> iConverter = this.lookupConverter(object);
        if (iConverter == null) {
            if (this.targetType == Canonical.class) {
                throw new ConversionException("can't convert " + object.getClass().getName() + " to " + this.getTargetType());
            }
            Canonical canonical = ConverterRegistry.get().convert(object, Canonical.class);
            if (canonical == object) {
                throw new ConversionException("can't convert " + object.getClass().getName() + " to " + this.getTargetType());
            }
            return ConverterRegistry.get().convert(canonical, this.getTargetType());
        }
        return iConverter.convert(object);
    }

    @Override
    public Class<?> getSourceType() {
        return Object.class;
    }

    @Override
    public Class<?> getTargetType() {
        return this.targetType;
    }

    private IConverter<?, ?> lookupConverter(Class<?> clazz) {
        IConverter<?, ?> iConverter = this.converters.get(clazz);
        if (iConverter != null) {
            return iConverter;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            iConverter = this.lookupConverter(classArray[n]);
            if (iConverter != null) {
                return iConverter;
            }
            ++n;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (iConverter = this.lookupConverter(clazz2)) != null) {
            return iConverter;
        }
        return null;
    }

    protected IConverter<?, ?> lookupConverter(Object object) {
        Class clazz = object == null ? Undefined.class : object.getClass();
        IConverter<?, ?> iConverter = this.lookupConverter(clazz);
        return iConverter;
    }

    public void registerConverter(IConverter iConverter) {
        this.converters.put(iConverter.getSourceType(), iConverter);
    }

    public void unregisterConverter(IConverter iConverter) {
        this.converters.remove(iConverter.getSourceType());
    }
}

