/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.IconHighlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconAware;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.AddOnDependencyChecker;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.CheckForUpdateCallback;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;
import org.zaproxy.zap.extension.autoupdate.InstalledAddOnsTableModel;
import org.zaproxy.zap.extension.autoupdate.UninstalledAddOnsTableModel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.LayoutHelper;

public class ManageAddOnsDialog
extends AbstractFrame
implements CheckForUpdateCallback {
    static final Icon ICON_ADD_ON_ISSUES = new ImageIcon(InstalledAddOnsTableModel.class.getResource("/resource/icon/16/050.png"));
    static final Icon ICON_ADD_ON_EXTENSION_ISSUES = new ImageIcon(InstalledAddOnsTableModel.class.getResource("/resource/icon/fugue/information-white.png"));
    private static final Logger logger = Logger.getLogger(ManageAddOnsDialog.class);
    private static final long serialVersionUID = 1L;
    private JTabbedPane jTabbed = null;
    private JPanel topPanel = null;
    private JPanel installedPanel = null;
    private JPanel browsePanel = null;
    private JPanel corePanel = null;
    private JPanel installedAddOnsPanel = null;
    private JPanel uninstalledAddOnsPanel = null;
    private JPanel retrievePanel = null;
    private JScrollPane marketPlaceScrollPane = null;
    private JButton addOnInfoButton = null;
    private JButton coreNotesButton = null;
    private JButton downloadZapButton = null;
    private JButton checkForUpdatesButton = null;
    private JButton updateButton = null;
    private JButton updateAllButton = null;
    private JButton uninstallButton = null;
    private JButton installButton = null;
    private JButton close1Button = null;
    private JButton close2Button = null;
    private JLabel downloadProgress = null;
    private JLabel updatesMessage = null;
    private JXTable installedAddOnsTable = null;
    private JXTable uninstalledAddOnsTable = null;
    private String currentVersion = null;
    private AddOnCollection latestInfo = null;
    private AddOnCollection prevInfo = null;
    private ExtensionAutoUpdate extension = null;
    private AddOnCollection installedAddOns;
    private final InstalledAddOnsTableModel installedAddOnsModel;
    private final UninstalledAddOnsTableModel uninstalledAddOnsModel;
    private State state = null;

    public ManageAddOnsDialog(ExtensionAutoUpdate extensionAutoUpdate, String string, AddOnCollection addOnCollection) throws HeadlessException {
        this.extension = extensionAutoUpdate;
        this.currentVersion = string;
        this.installedAddOns = addOnCollection;
        this.installedAddOnsModel = new InstalledAddOnsTableModel(addOnCollection);
        this.uninstalledAddOnsModel = new UninstalledAddOnsTableModel(addOnCollection);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("cfu.manage.title"));
        this.setContentPane(this.getTopPanel());
        this.pack();
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(700, 500);
        }
        this.state = State.IDLE;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
            this.topPanel.add((Component)this.getJTabbed(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
            this.topPanel.add((Component)this.getUpdatesMessage(), LayoutHelper.getGBC(0, 2, 1, 1.0));
        }
        return this.topPanel;
    }

    private JTabbedPane getJTabbed() {
        if (this.jTabbed == null) {
            this.jTabbed = new JTabbedPane();
            this.jTabbed.addTab(Constant.messages.getString("cfu.tab.installed"), this.getInstalledPanel());
            this.jTabbed.addTab(Constant.messages.getString("cfu.tab.browse"), this.getBrowsePanel());
        }
        return this.jTabbed;
    }

    protected void selectMarketplaceTab() {
        this.getJTabbed().setSelectedIndex(1);
    }

    private JPanel getInstalledPanel() {
        if (this.installedPanel == null) {
            this.installedPanel = new JPanel();
            this.installedPanel.setLayout(new GridBagLayout());
            this.installedPanel.add((Component)this.getCorePanel(true), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0));
            this.installedPanel.add((Component)this.getInstalledAddOnsPanel(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
        }
        return this.installedPanel;
    }

    private JPanel getBrowsePanel() {
        if (this.browsePanel == null) {
            this.browsePanel = new JPanel();
            this.browsePanel.setLayout(new GridBagLayout());
            this.browsePanel.add((Component)this.getUninstalledAddOnsPanel(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
        }
        return this.browsePanel;
    }

    private JPanel getCorePanel(boolean bl) {
        if (this.corePanel == null) {
            this.corePanel = new JPanel();
            this.corePanel.setLayout(new GridBagLayout());
            this.corePanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.zap.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            if (this.latestInfo == null || this.latestInfo.getZapRelease() == null) {
                this.corePanel.add((Component)new JLabel(this.currentVersion), LayoutHelper.getGBC(0, 0, 1, 0.0));
                this.corePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(1, 0, 1, 1.0));
                this.corePanel.add((Component)this.getCheckForUpdatesButton(), LayoutHelper.getGBC(2, 0, 1, 0.0));
            } else if (this.latestInfo.getZapRelease().isNewerThan(this.currentVersion)) {
                this.corePanel.add((Component)new JLabel(Constant.messages.getString("cfu.check.zap.newer")), LayoutHelper.getGBC(0, 0, 1, 0.0));
                this.corePanel.add((Component)new JLabel(this.latestInfo.getZapRelease().getVersion()), LayoutHelper.getGBC(1, 0, 1, 0.1));
                this.corePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 0.8));
                this.corePanel.add((Component)this.getDownloadProgress(), LayoutHelper.getGBC(3, 0, 1, 0.2));
                this.corePanel.add((Component)this.getCoreNotesButton(), LayoutHelper.getGBC(4, 0, 1, 0.0));
                this.corePanel.add((Component)this.getDownloadZapButton(), LayoutHelper.getGBC(5, 0, 1, 0.0));
            } else {
                this.corePanel.add((Component)new JLabel(this.currentVersion + " : " + Constant.messages.getString("cfu.check.zap.latest")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            }
        } else if (bl && this.latestInfo != null && this.latestInfo.getZapRelease() != null) {
            this.corePanel.removeAll();
            if (this.latestInfo.getZapRelease().isNewerThan(this.currentVersion)) {
                this.corePanel.add((Component)new JLabel(Constant.messages.getString("cfu.check.zap.newer")), LayoutHelper.getGBC(0, 0, 1, 0.0));
                this.corePanel.add((Component)new JLabel(this.latestInfo.getZapRelease().getVersion()), LayoutHelper.getGBC(1, 0, 1, 0.1));
                this.corePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 0.8));
                this.corePanel.add((Component)this.getDownloadProgress(), LayoutHelper.getGBC(3, 0, 1, 0.2));
                this.corePanel.add((Component)this.getCoreNotesButton(), LayoutHelper.getGBC(4, 0, 1, 0.0));
                this.corePanel.add((Component)this.getDownloadZapButton(), LayoutHelper.getGBC(5, 0, 1, 0.0));
            } else {
                this.corePanel.add((Component)new JLabel(this.currentVersion + " : " + Constant.messages.getString("cfu.check.zap.latest")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            }
            this.installedPanel.validate();
        }
        return this.corePanel;
    }

    private JPanel getInstalledAddOnsPanel() {
        if (this.installedAddOnsPanel == null) {
            this.installedAddOnsPanel = new JPanel();
            this.installedAddOnsPanel.setLayout(new GridBagLayout());
            this.installedAddOnsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.addons.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            this.getInstalledAddOnsTable();
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setViewportView((Component)this.getInstalledAddOnsTable());
            int n = 0;
            this.installedAddOnsPanel.add((Component)jScrollPane, LayoutHelper.getGBC(0, n++, 5, 1.0, 1.0));
            this.installedAddOnsPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, n, 1, 1.0));
            this.installedAddOnsPanel.add((Component)this.getUninstallButton(), LayoutHelper.getGBC(1, n, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getUpdateButton(), LayoutHelper.getGBC(2, n, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getUpdateAllButton(), LayoutHelper.getGBC(3, n, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getClose1Button(), LayoutHelper.getGBC(4, n, 1, 0.0));
        }
        return this.installedAddOnsPanel;
    }

    private JPanel getUninstalledAddOnsPanel() {
        if (this.uninstalledAddOnsPanel == null) {
            this.uninstalledAddOnsPanel = new JPanel();
            this.uninstalledAddOnsPanel.setLayout(new GridBagLayout());
            this.uninstalledAddOnsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.addons.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            if (this.latestInfo == null) {
                this.getUninstalledAddOnsTable();
                this.getMarketPlaceScrollPane().setViewportView(this.getRetrievePanel());
            } else {
                this.getMarketPlaceScrollPane().setViewportView((Component)this.getUninstalledAddOnsTable());
            }
            int n = 0;
            this.uninstalledAddOnsPanel.add((Component)this.getMarketPlaceScrollPane(), LayoutHelper.getGBC(0, n++, 4, 1.0, 1.0));
            this.uninstalledAddOnsPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, n, 1, 1.0));
            this.uninstalledAddOnsPanel.add((Component)this.getInstallButton(), LayoutHelper.getGBC(1, n, 1, 0.0));
            this.uninstalledAddOnsPanel.add((Component)this.getAddOnInfoButton(), LayoutHelper.getGBC(2, n, 1, 0.0));
            this.uninstalledAddOnsPanel.add((Component)this.getClose2Button(), LayoutHelper.getGBC(3, n, 1, 0.0));
        }
        return this.uninstalledAddOnsPanel;
    }

    private JScrollPane getMarketPlaceScrollPane() {
        if (this.marketPlaceScrollPane == null) {
            this.marketPlaceScrollPane = new JScrollPane();
            this.marketPlaceScrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.marketPlaceScrollPane;
    }

    private JPanel getRetrievePanel() {
        if (this.retrievePanel == null) {
            this.retrievePanel = new JPanel();
            this.retrievePanel.setLayout(new GridBagLayout());
            JButton jButton = new JButton();
            jButton.setText(Constant.messages.getString("cfu.button.checkForUpdates"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageAddOnsDialog.this.checkForUpdates();
                }
            });
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.retrievePanel.add((Component)jButton, LayoutHelper.getGBC(1, 0, 1, 0.0));
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 1.0));
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 1, 3, 1.0, 1.0));
        }
        return this.retrievePanel;
    }

    protected void setPreviousVersionInfo(AddOnCollection addOnCollection) {
        this.prevInfo = addOnCollection;
    }

    protected void setLatestVersionInfo(AddOnCollection addOnCollection) {
        this.latestInfo = addOnCollection;
        this.getCorePanel(true);
        if (addOnCollection != null) {
            this.installedAddOnsModel.setAvailableAddOns(addOnCollection);
            this.uninstalledAddOnsModel.setAddOnCollection(addOnCollection);
            List<AddOn> list = this.installedAddOnsModel.updateEntries();
            this.uninstalledAddOnsModel.setAddOns(list, this.prevInfo);
        }
        this.getMarketPlaceScrollPane().setViewportView((Component)this.getUninstalledAddOnsTable());
    }

    private JXTable getInstalledAddOnsTable() {
        if (this.installedAddOnsTable == null) {
            this.installedAddOnsTable = new JXTable();
            this.installedAddOnsTable.setSortable(false);
            this.installedAddOnsModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    ManageAddOnsDialog.this.getUpdateButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.canUpdateSelected());
                    ManageAddOnsDialog.this.getUpdateAllButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.getAllUpdates().size() > 0);
                    ManageAddOnsDialog.this.getUninstallButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.canUninstallSelected());
                }
            });
            this.installedAddOnsTable.setModel((TableModel)this.installedAddOnsModel);
            this.installedAddOnsTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            this.installedAddOnsTable.getColumnModel().getColumn(1).setPreferredWidth(400);
            this.installedAddOnsTable.getColumnModel().getColumn(2).setPreferredWidth(60);
            this.installedAddOnsTable.getColumnModel().getColumn(3).setPreferredWidth(40);
            this.installedAddOnsTable.getColumnModel().getColumn(0).setMaxWidth(20);
            this.installedAddOnsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            this.installedAddOnsTable.getColumnModel().getColumn(2).setPreferredWidth(400);
            this.installedAddOnsTable.getColumnModel().getColumn(3).setPreferredWidth(60);
            this.installedAddOnsTable.getColumnModel().getColumn(4).setPreferredWidth(40);
            DefaultAddOnToolTipHighlighter defaultAddOnToolTipHighlighter = new DefaultAddOnToolTipHighlighter(-1);
            for (int i = 1; i < this.installedAddOnsTable.getColumnCount(); ++i) {
                this.installedAddOnsTable.getColumnExt(i).addHighlighter((Highlighter)defaultAddOnToolTipHighlighter);
            }
            this.installedAddOnsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.installedAddOnsTable.getColumnExt(0).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningRunningIssuesHighlighter(-1), new WarningRunningIssuesToolTipHighlighter(-1)})});
            this.installedAddOnsTable.getColumnExt(3).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningUpdateIssuesHighlighter(-1), new WarningUpdateIssuesToolTipHighlighter(-1)})});
            this.installedAddOnsTable.getColumnExt(4).addHighlighter((Highlighter)new DisableSelectionHighlighter(-1));
        }
        return this.installedAddOnsTable;
    }

    private JXTable getUninstalledAddOnsTable() {
        if (this.uninstalledAddOnsTable == null) {
            this.uninstalledAddOnsTable = new JXTable();
            this.uninstalledAddOnsTable.setSortable(false);
            this.uninstalledAddOnsModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    ManageAddOnsDialog.this.getInstallButton().setEnabled(ManageAddOnsDialog.this.uninstalledAddOnsModel.canIinstallSelected());
                }
            });
            this.uninstalledAddOnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    AddOnWrapper addOnWrapper;
                    ManageAddOnsDialog.this.getAddOnInfoButton().setEnabled(false);
                    if (DesktopUtils.canOpenUrlInBrowser() && ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRowCount() == 1 && (addOnWrapper = ManageAddOnsDialog.this.uninstalledAddOnsModel.getAddOnWrapper(ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow())) != null && addOnWrapper.getAddOn().getInfo() != null) {
                        ManageAddOnsDialog.this.getAddOnInfoButton().setEnabled(true);
                    }
                }
            });
            this.uninstalledAddOnsTable.setModel((TableModel)this.uninstalledAddOnsModel);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(0).setMaxWidth(20);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(1).setPreferredWidth(50);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(2).setPreferredWidth(150);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(3).setPreferredWidth(300);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(4).setPreferredWidth(60);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(5).setPreferredWidth(40);
            DefaultAddOnToolTipHighlighter defaultAddOnToolTipHighlighter = new DefaultAddOnToolTipHighlighter(-1);
            for (int i = 1; i < this.uninstalledAddOnsTable.getColumnCount(); ++i) {
                this.uninstalledAddOnsTable.getColumnExt(i).addHighlighter((Highlighter)defaultAddOnToolTipHighlighter);
            }
            this.uninstalledAddOnsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.uninstalledAddOnsTable.getColumnExt(0).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningRunningIssuesHighlighter(-1), new WarningRunningIssuesToolTipHighlighter(-1)})});
            this.uninstalledAddOnsTable.getColumnExt(5).addHighlighter((Highlighter)new DisableSelectionHighlighter(-1));
        }
        return this.uninstalledAddOnsTable;
    }

    private String addOnToHtml(AddOn addOn) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<table>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.name"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(addOn.getName());
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.status"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(Constant.messages.getString("cfu.status." + addOn.getStatus().name()));
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.id"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(addOn.getId());
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.desc"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(addOn.getDescription());
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.author"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(addOn.getAuthor());
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.changes"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(addOn.getChanges());
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.version"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(addOn.getFileVersion());
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.notbefore"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(addOn.getNotBeforeVersion());
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td><i>");
        stringBuilder.append(Constant.messages.getString("cfu.table.header.notfrom"));
        stringBuilder.append("</i></td><td>");
        stringBuilder.append(addOn.getNotFromVersion());
        stringBuilder.append("</td></tr>");
        if (!addOn.getIdsAddOnDependencies().isEmpty()) {
            stringBuilder.append("<tr><td><i>");
            stringBuilder.append(Constant.messages.getString("cfu.table.header.dependencies"));
            stringBuilder.append("</i></td><td>");
            for (String string : addOn.getIdsAddOnDependencies()) {
                AddOn addOn2 = this.installedAddOns.getAddOn(string);
                if (addOn2 == null && this.latestInfo != null) {
                    addOn2 = this.latestInfo.getAddOn(string);
                }
                if (addOn2 != null) {
                    stringBuilder.append(addOn2.getName());
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append("<br>");
            }
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private JLabel getUpdatesMessage() {
        if (this.updatesMessage == null) {
            this.updatesMessage = new JLabel(" ");
        }
        return this.updatesMessage;
    }

    private JButton getCoreNotesButton() {
        if (this.coreNotesButton == null) {
            this.coreNotesButton = new JButton();
            this.coreNotesButton.setIcon(new ImageIcon(ManageAddOnsDialog.class.getResource("/resource/icon/16/022.png")));
            this.coreNotesButton.setToolTipText(Constant.messages.getString("cfu.button.zap.relnotes"));
            final ManageAddOnsDialog manageAddOnsDialog = this;
            this.coreNotesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray;
                    URL uRL = ManageAddOnsDialog.this.latestInfo.getZapRelease().getReleaseNotesUrl();
                    if (uRL != null && DesktopUtils.canOpenUrlInBrowser() && DesktopUtils.openUrlInBrowser(uRL.toString())) {
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html>");
                    stringBuilder.append(MessageFormat.format(Constant.messages.getString("cfu.title.relnotes"), ManageAddOnsDialog.this.latestInfo.getZapRelease().getVersion()));
                    for (String string : stringArray = ManageAddOnsDialog.this.latestInfo.getZapRelease().getReleaseNotes().split("\n")) {
                        stringBuilder.append(string.replace("&lt;", "<").trim());
                    }
                    stringBuilder.append("</html>");
                    View.getSingleton().showMessageDialog(manageAddOnsDialog, stringBuilder.toString());
                }
            });
        }
        return this.coreNotesButton;
    }

    private JButton getClose1Button() {
        if (this.close1Button == null) {
            this.close1Button = new JButton();
            this.close1Button.setText(Constant.messages.getString("all.button.close"));
            this.close1Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageAddOnsDialog.this.dispose();
                }
            });
        }
        return this.close1Button;
    }

    private JButton getClose2Button() {
        if (this.close2Button == null) {
            this.close2Button = new JButton();
            this.close2Button.setText(Constant.messages.getString("all.button.close"));
            this.close2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageAddOnsDialog.this.dispose();
                }
            });
        }
        return this.close2Button;
    }

    private JLabel getDownloadProgress() {
        if (this.downloadProgress == null) {
            this.downloadProgress = new JLabel("");
        }
        return this.downloadProgress;
    }

    private JButton getCheckForUpdatesButton() {
        if (this.checkForUpdatesButton == null) {
            this.checkForUpdatesButton = new JButton();
            this.checkForUpdatesButton.setText(Constant.messages.getString("cfu.button.checkForUpdates"));
            this.checkForUpdatesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageAddOnsDialog.this.checkForUpdates();
                }
            });
        }
        return this.checkForUpdatesButton;
    }

    protected void checkForUpdates() {
        this.setCursor(new Cursor(3));
        this.extension.getLatestVersionInfo(this);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private JButton getDownloadZapButton() {
        if (this.downloadZapButton == null) {
            this.downloadZapButton = new JButton();
            if (Constant.isKali()) {
                this.getDownloadZapButton().setText(Constant.messages.getString("cfu.button.zap.options"));
            } else {
                this.downloadZapButton.setText(Constant.messages.getString("cfu.button.zap.download"));
            }
            this.downloadZapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ManageAddOnsDialog.this.extension.downloadLatestRelease()) {
                        ManageAddOnsDialog.this.setDownloadingZap();
                    }
                }
            });
        }
        return this.downloadZapButton;
    }

    protected void setDownloadingZap() {
        this.downloadZapButton.setEnabled(false);
        this.getUpdateButton().setEnabled(false);
        this.getUpdateAllButton().setEnabled(false);
        this.state = State.DOWNLOADING_ZAP;
        this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.zap.downloading"));
    }

    protected void setDownloadingUpdates() {
        if (EventQueue.isDispatchThread()) {
            this.getDownloadZapButton().setEnabled(false);
            this.getUpdateButton().setEnabled(false);
            this.getUpdateAllButton().setEnabled(false);
            this.state = State.DOWNLOADING_UPDATES;
            this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.upd.downloading"));
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.setDownloadingUpdates();
                }
            });
        }
    }

    public void notifyAddOnDownloading(AddOn addOn) {
        if (this.installedAddOnsModel.notifyAddOnDownloading(addOn)) {
            return;
        }
        this.uninstalledAddOnsModel.notifyAddOnDownloading(addOn);
    }

    public void notifyAddOnDownloadFailed(String string) {
        if (this.installedAddOnsModel.notifyAddOnDownloadFailed(string)) {
            return;
        }
        this.uninstalledAddOnsModel.notifyAddOnDownloadFailed(string);
    }

    public void notifyAddOnInstalled(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            if (this.latestInfo != null && this.latestInfo.getAddOn(addOn.getId()) != null) {
                this.uninstalledAddOnsModel.removeAddOn(addOn);
            }
            this.installedAddOnsModel.addOrRefreshAddOn(addOn);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnInstalled(addOn);
                }
            });
        }
    }

    public void notifyAddOnFailedUninstallation(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            this.installedAddOnsModel.notifyAddOnFailedUninstallation(addOn);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnFailedUninstallation(addOn);
                }
            });
        }
    }

    public void notifyAddOnUninstalled(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            AddOn addOn2;
            this.installedAddOnsModel.removeAddOn(addOn);
            if (this.latestInfo != null && (addOn2 = this.latestInfo.getAddOn(addOn.getId())) != null) {
                this.uninstalledAddOnsModel.addAddOn(this.latestInfo.getAddOn(addOn.getId()));
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnUninstalled(addOn);
                }
            });
        }
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText(Constant.messages.getString("cfu.button.addons.update"));
            this.updateButton.setEnabled(false);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageAddOnsDialog.this.processUpdates(ManageAddOnsDialog.this.installedAddOnsModel.getSelectedUpdates());
                }
            });
        }
        return this.updateButton;
    }

    private JButton getUpdateAllButton() {
        if (this.updateAllButton == null) {
            this.updateAllButton = new JButton();
            this.updateAllButton.setText(Constant.messages.getString("cfu.button.addons.updateAll"));
            this.updateAllButton.setEnabled(false);
            this.updateAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageAddOnsDialog.this.processUpdates(ManageAddOnsDialog.this.installedAddOnsModel.getAllUpdates());
                }
            });
        }
        return this.updateAllButton;
    }

    private void processUpdates(Set<AddOn> set) {
        if (set.isEmpty()) {
            return;
        }
        AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(this.installedAddOns, this.latestInfo);
        AddOnDependencyChecker.AddOnChangesResult addOnChangesResult = addOnDependencyChecker.calculateUpdateChanges(set);
        if (!addOnDependencyChecker.confirmUpdateChanges(this, addOnChangesResult)) {
            return;
        }
        this.extension.processAddOnChanges(this, addOnChangesResult);
    }

    private JButton getUninstallButton() {
        if (this.uninstallButton == null) {
            this.uninstallButton = new JButton();
            this.uninstallButton.setText(Constant.messages.getString("cfu.button.addons.uninstall"));
            this.uninstallButton.setEnabled(false);
            this.uninstallButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Set<AddOn> set = ManageAddOnsDialog.this.installedAddOnsModel.getSelectedAddOns();
                    if (set.isEmpty()) {
                        return;
                    }
                    Set<AddOn> set2 = ManageAddOnsDialog.this.installedAddOnsModel.getDownloadingAddOns();
                    set2.addAll(ManageAddOnsDialog.this.uninstalledAddOnsModel.getDownloadingAddOns());
                    AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(ManageAddOnsDialog.this.installedAddOns, ManageAddOnsDialog.this.latestInfo);
                    AddOnDependencyChecker.UninstallationResult uninstallationResult = addOnDependencyChecker.calculateUninstallChanges(set);
                    if (!addOnDependencyChecker.confirmUninstallChanges(ManageAddOnsDialog.this, uninstallationResult, set2)) {
                        return;
                    }
                    Set<AddOn> set3 = uninstallationResult.getUninstallations();
                    Set<Extension> set4 = uninstallationResult.getExtensions();
                    if (!ManageAddOnsDialog.this.extension.warnUnsavedResourcesOrActiveActions(ManageAddOnsDialog.this, set3, set4, false)) {
                        return;
                    }
                    ManageAddOnsDialog.this.extension.uninstallAddOnsWithView(ManageAddOnsDialog.this, set3, false, new HashSet<AddOn>());
                }
            });
        }
        return this.uninstallButton;
    }

    private JButton getInstallButton() {
        if (this.installButton == null) {
            this.installButton = new JButton();
            this.installButton.setText(Constant.messages.getString("cfu.button.addons.install"));
            this.installButton.setEnabled(false);
            this.installButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddOnDependencyChecker.AddOnChangesResult addOnChangesResult;
                    Set<AddOn> set = ManageAddOnsDialog.this.uninstalledAddOnsModel.getSelectedAddOns();
                    if (set.isEmpty()) {
                        return;
                    }
                    AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(ManageAddOnsDialog.this.installedAddOns, ManageAddOnsDialog.this.latestInfo);
                    if (!addOnDependencyChecker.confirmInstallChanges(ManageAddOnsDialog.this, addOnChangesResult = addOnDependencyChecker.calculateInstallChanges(set))) {
                        return;
                    }
                    ManageAddOnsDialog.this.extension.processAddOnChanges(ManageAddOnsDialog.this, addOnChangesResult);
                }
            });
        }
        return this.installButton;
    }

    private JButton getAddOnInfoButton() {
        if (this.addOnInfoButton == null) {
            this.addOnInfoButton = new JButton();
            this.addOnInfoButton.setText(Constant.messages.getString("cfu.button.addons.info"));
            this.addOnInfoButton.setEnabled(false);
            this.addOnInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddOnWrapper addOnWrapper;
                    if (ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow() >= 0 && (addOnWrapper = ManageAddOnsDialog.this.uninstalledAddOnsModel.getAddOnWrapper(ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow())) != null && addOnWrapper.getAddOn().getInfo() != null) {
                        DesktopUtils.openUrlInBrowser(addOnWrapper.getAddOn().getInfo().toString());
                    }
                }
            });
        }
        return this.addOnInfoButton;
    }

    public void showProgress() {
        if (this.state.equals((Object)State.DOWNLOADING_UPDATES)) {
            this.installedAddOnsModel.updateDownloadsProgresses(this.extension);
            this.uninstalledAddOnsModel.updateDownloadsProgresses(this.extension);
            if (this.extension.getCurrentDownloadCount() == 0) {
                this.state = State.DOWNLOADED_UPDATES;
                this.getDownloadZapButton().setEnabled(true);
                this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.upd.downloaded"));
            }
        } else if (this.state.equals((Object)State.DOWNLOADING_ZAP)) {
            try {
                int n = this.extension.getDownloadProgressPercent(this.latestInfo.getZapRelease().getUrl());
                if (n > 0) {
                    this.getDownloadProgress().setText(n + "%");
                    if (n >= 100) {
                        this.zapDownloadComplete();
                    }
                }
            }
            catch (Exception exception) {
                logger.debug((Object)("Error on " + this.latestInfo.getZapRelease().getUrl()), (Throwable)exception);
                this.getDownloadProgress().setText(Constant.messages.getString("cfu.table.label.failed"));
            }
        }
    }

    private void zapDownloadComplete() {
        if (this.state.equals((Object)State.DOWNLOADED_ZAP)) {
            return;
        }
        this.state = State.DOWNLOADED_ZAP;
        File file = new File(Constant.FOLDER_LOCAL_PLUGIN, this.latestInfo.getZapRelease().getFileName());
        if (Desktop.isDesktopSupported()) {
            this.extension.promptToLaunchReleaseAndClose(this.latestInfo.getZapRelease().getVersion(), file);
        } else {
            View.getSingleton().showWarningDialog(this, MessageFormat.format(Constant.messages.getString("cfu.warn.nolaunch"), this.latestInfo.getZapRelease().getVersion(), file.getAbsolutePath()));
        }
        this.getUpdateButton().setEnabled(true);
        this.getUpdateAllButton().setEnabled(true);
        this.getUpdatesMessage().setText(MessageFormat.format(Constant.messages.getString("cfu.check.zap.downloaded"), file.getAbsolutePath()));
    }

    @Override
    public void gotLatestData(AddOnCollection addOnCollection) {
        logger.debug((Object)("gotLatestData(AddOnCollection " + addOnCollection));
        if (addOnCollection != null) {
            this.setLatestVersionInfo(addOnCollection);
        } else {
            View.getSingleton().showWarningDialog(this, Constant.messages.getString("cfu.check.failed"));
        }
    }

    @Override
    public void insecureUrl(String string, Exception exception) {
        logger.error((Object)("Failed to get check for updates on " + string), (Throwable)exception);
        View.getSingleton().showWarningDialog(this, Constant.messages.getString("cfu.warn.badurl"));
    }

    private class WarningUpdateIssuesToolTipHighlighter
    extends DefaultAddOnToolTipHighlighter {
        public WarningUpdateIssuesToolTipHighlighter(int n) {
            super(n);
        }

        @Override
        protected String getToolTip(AddOnWrapper addOnWrapper) {
            if (addOnWrapper.hasUpdateIssues()) {
                return addOnWrapper.getUpdateIssues();
            }
            return super.getToolTip(addOnWrapper);
        }
    }

    private class WarningRunningIssuesToolTipHighlighter
    extends DefaultAddOnToolTipHighlighter {
        public WarningRunningIssuesToolTipHighlighter(int n) {
            super(n);
        }

        @Override
        protected String getToolTip(AddOnWrapper addOnWrapper) {
            if (addOnWrapper.hasRunningIssues()) {
                return addOnWrapper.getRunningIssues();
            }
            return super.getToolTip(addOnWrapper);
        }
    }

    private class DefaultAddOnToolTipHighlighter
    extends AbstractHighlighter {
        private final int column;

        public DefaultAddOnToolTipHighlighter(int n) {
            this.column = n;
        }

        protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
            ((JComponent)component).setToolTipText(this.getToolTip((AddOnWrapper)componentAdapter.getValue(this.column)));
            return component;
        }

        protected String getToolTip(AddOnWrapper addOnWrapper) {
            if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus()) {
                return ManageAddOnsDialog.this.addOnToHtml(addOnWrapper.getAddOn());
            }
            AddOn addOn = addOnWrapper.getAddOnUpdate() != null ? addOnWrapper.getAddOnUpdate() : addOnWrapper.getAddOn();
            return ManageAddOnsDialog.this.addOnToHtml(addOn);
        }
    }

    private static class WarningUpdateIssuesHighlighter
    extends IconHighlighter {
        private final int columnIndex;

        public WarningUpdateIssuesHighlighter(int n) {
            this.columnIndex = n;
            this.setHighlightPredicate(new HighlightPredicate(){

                public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
                    AddOnWrapper addOnWrapper = (AddOnWrapper)componentAdapter.getValue(WarningUpdateIssuesHighlighter.this.columnIndex);
                    if (AddOnWrapper.Status.newVersion == addOnWrapper.getStatus()) {
                        return addOnWrapper.hasUpdateIssues();
                    }
                    return false;
                }
            });
        }

        public Icon getIcon(ComponentAdapter componentAdapter) {
            AddOnWrapper addOnWrapper = (AddOnWrapper)componentAdapter.getValue(this.columnIndex);
            if (addOnWrapper.isAddOnUpdateIssues()) {
                return ICON_ADD_ON_ISSUES;
            }
            return ICON_ADD_ON_EXTENSION_ISSUES;
        }

        protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
            if (component instanceof IconAware) {
                ((IconAware)component).setIcon(this.getIcon(componentAdapter));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(this.getIcon(componentAdapter));
            }
            return component;
        }
    }

    private static class WarningRunningIssuesHighlighter
    extends IconHighlighter {
        private final int columnIndex;

        public WarningRunningIssuesHighlighter(int n) {
            this.columnIndex = n;
            this.setHighlightPredicate((HighlightPredicate)new HighlightPredicate.EqualsHighlightPredicate((Object)Boolean.TRUE));
        }

        public Icon getIcon(ComponentAdapter componentAdapter) {
            AddOnWrapper addOnWrapper = (AddOnWrapper)componentAdapter.getValue(this.columnIndex);
            if (addOnWrapper.isAddOnRunningIssues()) {
                return ICON_ADD_ON_ISSUES;
            }
            return ICON_ADD_ON_EXTENSION_ISSUES;
        }

        protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
            if (component instanceof IconAware) {
                ((IconAware)component).setIcon(this.getIcon(componentAdapter));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(this.getIcon(componentAdapter));
            }
            return component;
        }
    }

    private static class DisableSelectionHighlighter
    extends AbstractHighlighter {
        public DisableSelectionHighlighter(final int n) {
            this.setHighlightPredicate(new HighlightPredicate(){

                public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
                    AddOn.InstallationStatus installationStatus = ((AddOnWrapper)componentAdapter.getValue(n)).getInstallationStatus();
                    return AddOn.InstallationStatus.UNINSTALLATION_FAILED == installationStatus || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == installationStatus || AddOn.InstallationStatus.DOWNLOADING == installationStatus;
                }
            });
        }

        protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
            component.setEnabled(false);
            return component;
        }
    }

    protected static enum State {
        IDLE,
        DOWNLOADING_ZAP,
        DOWNLOADED_ZAP,
        DOWNLOADING_UPDATES,
        DOWNLOADED_UPDATES;

    }
}

