/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableIntegerProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.util.Callback;

@DefaultProperty(value="pages")
public class Pagination
extends Control {
    private static final int DEFAULT_MAX_PAGE_INDICATOR_COUNT = 10;
    public static final String STYLE_CLASS_BULLET = "bullet";
    public static final int INDETERMINATE = Integer.MAX_VALUE;
    private int oldMaxPageIndicatorCount = 10;
    private IntegerProperty maxPageIndicatorCount;
    private int oldPageCount = Integer.MAX_VALUE;
    private IntegerProperty pageCount = new SimpleIntegerProperty(this, "pageCount", Integer.MAX_VALUE){

        @Override
        protected void invalidated() {
            if (!Pagination.this.pageCount.isBound()) {
                if (Pagination.this.getPageCount() < 1) {
                    Pagination.this.setPageCount(Pagination.this.oldPageCount);
                }
                Pagination.this.oldPageCount = Pagination.this.getPageCount();
            }
        }
    };
    private final IntegerProperty currentPageIndex = new SimpleIntegerProperty(this, "currentPageIndex", 0){

        @Override
        protected void invalidated() {
            if (!Pagination.this.currentPageIndex.isBound()) {
                if (Pagination.this.getCurrentPageIndex() < 0) {
                    Pagination.this.setCurrentPageIndex(0);
                } else if (Pagination.this.getCurrentPageIndex() > Pagination.this.getPageCount() - 1) {
                    Pagination.this.setCurrentPageIndex(Pagination.this.getPageCount() - 1);
                }
            }
        }
    };
    private ObjectProperty<Callback<Integer, Node>> pageFactory = new SimpleObjectProperty<Callback<Integer, Node>>(this, "pageFactory");
    private static final String DEFAULT_STYLE_CLASS = "pagination";

    public Pagination(int n, int n2) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setPageCount(n);
        this.setCurrentPageIndex(n2);
    }

    public Pagination(int n) {
        this(n, 0);
    }

    public Pagination() {
        this(Integer.MAX_VALUE, 0);
    }

    public final void setMaxPageIndicatorCount(int n) {
        this.maxPageIndicatorCountProperty().set(n);
    }

    public final int getMaxPageIndicatorCount() {
        return this.maxPageIndicatorCount == null ? 10 : this.maxPageIndicatorCount.get();
    }

    public final IntegerProperty maxPageIndicatorCountProperty() {
        if (this.maxPageIndicatorCount == null) {
            this.maxPageIndicatorCount = new StyleableIntegerProperty(10){

                @Override
                protected void invalidated() {
                    if (!Pagination.this.maxPageIndicatorCount.isBound()) {
                        if (Pagination.this.getMaxPageIndicatorCount() < 1 || Pagination.this.getMaxPageIndicatorCount() > Pagination.this.getPageCount()) {
                            Pagination.this.setMaxPageIndicatorCount(Pagination.this.oldMaxPageIndicatorCount);
                        }
                        Pagination.this.oldMaxPageIndicatorCount = Pagination.this.getMaxPageIndicatorCount();
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.MAX_PAGE_INDICATOR_COUNT;
                }

                @Override
                public Object getBean() {
                    return Pagination.this;
                }

                @Override
                public String getName() {
                    return "maxPageIndicatorCount";
                }
            };
        }
        return this.maxPageIndicatorCount;
    }

    public final void setPageCount(int n) {
        this.pageCount.set(n);
    }

    public final int getPageCount() {
        return this.pageCount.get();
    }

    public final IntegerProperty pageCountProperty() {
        return this.pageCount;
    }

    public final void setCurrentPageIndex(int n) {
        this.currentPageIndex.set(n);
    }

    public final int getCurrentPageIndex() {
        return this.currentPageIndex.get();
    }

    public final IntegerProperty currentPageIndexProperty() {
        return this.currentPageIndex;
    }

    public final void setPageFactory(Callback<Integer, Node> callback) {
        this.pageFactory.set(callback);
    }

    public final Callback<Integer, Node> getPageFactory() {
        return (Callback)this.pageFactory.get();
    }

    public final ObjectProperty<Callback<Integer, Node>> pageFactoryProperty() {
        return this.pageFactory;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Pagination.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Pagination, Number> MAX_PAGE_INDICATOR_COUNT = new StyleableProperty<Pagination, Number>("-fx-max-page-indicator-count", (StyleConverter)SizeConverter.getInstance(), (Number)10){

            @Override
            public void set(Pagination pagination, Number number, Stylesheet.Origin origin) {
                super.set(pagination, number.intValue(), origin);
            }

            @Override
            public boolean isSettable(Pagination pagination) {
                return pagination.maxPageIndicatorCount == null || !pagination.maxPageIndicatorCount.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(Pagination pagination) {
                return pagination.maxPageIndicatorCountProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, MAX_PAGE_INDICATOR_COUNT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

