/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;

public abstract class ReplicaShardAllocator
extends AbstractComponent {
    public ReplicaShardAllocator(Settings settings) {
        super(settings);
    }

    public boolean processExistingRecoveries(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes.RoutingNodesIterator nodes = allocation.routingNodes().nodes();
        while (nodes.hasNext()) {
            nodes.next();
            RoutingNodes.RoutingNodeIterator it = nodes.nodeShards();
            while (it.hasNext()) {
                DiscoveryNode nodeWithHighestMatch;
                DiscoveryNode currentNode;
                ShardRouting shard = it.next();
                if (shard.primary() || !shard.initializing() || shard.relocatingNodeId() != null || !shard.allocatedPostIndexCreate()) continue;
                AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = this.fetchData(shard, allocation);
                if (!shardStores.hasData()) {
                    this.logger.trace("{}: fetching new stores for initializing shard", shard);
                    continue;
                }
                ShardRouting primaryShard = allocation.routingNodes().activePrimary(shard);
                assert (primaryShard != null) : "the replica shard can be allocated on at least one node, so there must be an active primary";
                TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore = this.findStore(primaryShard, allocation, shardStores);
                if (primaryStore == null || !primaryStore.allocated()) {
                    this.logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", shard);
                    continue;
                }
                MatchingNodes matchingNodes = this.findMatchingNodes(shard, allocation, primaryStore, shardStores);
                if (matchingNodes.getNodeWithHighestMatch() == null || (currentNode = allocation.nodes().get(shard.currentNodeId())).equals(nodeWithHighestMatch = matchingNodes.getNodeWithHighestMatch()) || matchingNodes.isNodeMatchBySyncID(currentNode) || !matchingNodes.isNodeMatchBySyncID(nodeWithHighestMatch)) continue;
                it.moveToUnassigned(new UnassignedInfo(UnassignedInfo.Reason.REALLOCATED_REPLICA, "existing allocation of replica to [" + currentNode + "] cancelled, sync id match found on node [" + nodeWithHighestMatch + "]"));
                changed = true;
            }
        }
        return changed;
    }

    public boolean allocateUnassigned(RoutingAllocation allocation) {
        return this.allocateUnassigned(allocation, System.currentTimeMillis());
    }

    public boolean allocateUnassigned(RoutingAllocation allocation, long allocateUnassignedTimestapm) {
        boolean changed = false;
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shard = unassignedIterator.next();
            if (shard.primary() || !shard.allocatedPostIndexCreate()) continue;
            if (!this.canBeAllocatedToAtLeastOneNode(shard, allocation)) {
                this.logger.trace("{}: ignoring allocation, can't be allocated on any node", shard);
                unassignedIterator.removeAndIgnore();
                continue;
            }
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = this.fetchData(shard, allocation);
            if (!shardStores.hasData()) {
                this.logger.trace("{}: ignoring allocation, still fetching shard stores", shard);
                allocation.setHasPendingAsyncFetch();
                unassignedIterator.removeAndIgnore();
                continue;
            }
            ShardRouting primaryShard = routingNodes.activePrimary(shard);
            assert (primaryShard != null) : "the replica shard can be allocated on at least one node, so there must be an active primary";
            TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore = this.findStore(primaryShard, allocation, shardStores);
            if (primaryStore == null || !primaryStore.allocated()) {
                this.logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", shard);
                continue;
            }
            MatchingNodes matchingNodes = this.findMatchingNodes(shard, allocation, primaryStore, shardStores);
            if (matchingNodes.getNodeWithHighestMatch() != null) {
                RoutingNode nodeWithHighestMatch = allocation.routingNodes().node(matchingNodes.getNodeWithHighestMatch().id());
                Decision decision = allocation.deciders().canAllocate(shard, nodeWithHighestMatch, allocation);
                if (decision.type() == Decision.Type.THROTTLE) {
                    this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store", shard.index(), shard.id(), shard, nodeWithHighestMatch.node());
                    unassignedIterator.removeAndIgnore();
                    continue;
                }
                this.logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store", shard.index(), shard.id(), shard, nodeWithHighestMatch.node());
                changed = true;
                unassignedIterator.initialize(nodeWithHighestMatch.nodeId(), shard.version(), allocation.clusterInfo().getShardSize(shard, -1L));
                continue;
            }
            if (matchingNodes.hasAnyData()) continue;
            IndexMetaData indexMetaData = allocation.metaData().index(shard.getIndex());
            long delay = shard.unassignedInfo().getDelayAllocationExpirationIn(allocateUnassignedTimestapm, this.settings, indexMetaData.getSettings());
            if (delay <= 0L) continue;
            this.logger.debug("[{}][{}]: delaying allocation of [{}] for [{}]", shard.index(), shard.id(), shard, TimeValue.timeValueMillis(delay));
            changed = true;
            unassignedIterator.removeAndIgnore();
        }
        return changed;
    }

    private boolean canBeAllocatedToAtLeastOneNode(ShardRouting shard, RoutingAllocation allocation) {
        for (ObjectCursor cursor : allocation.nodes().dataNodes().values()) {
            Decision decision;
            RoutingNode node = allocation.routingNodes().node(((DiscoveryNode)cursor.value).id());
            if (node == null || (decision = allocation.deciders().canAllocate(shard, node, allocation)).type() != Decision.Type.YES) continue;
            return true;
        }
        return false;
    }

    private TransportNodesListShardStoreMetaData.StoreFilesMetaData findStore(ShardRouting shard, RoutingAllocation allocation, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> data) {
        assert (shard.currentNodeId() != null);
        DiscoveryNode primaryNode = allocation.nodes().get(shard.currentNodeId());
        if (primaryNode == null) {
            return null;
        }
        TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData primaryNodeFilesStore = data.getData().get(primaryNode);
        if (primaryNodeFilesStore == null) {
            return null;
        }
        return primaryNodeFilesStore.storeFilesMetaData();
    }

    private MatchingNodes findMatchingNodes(ShardRouting shard, RoutingAllocation allocation, TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> data) {
        ObjectLongHashMap nodesToSize = new ObjectLongHashMap();
        for (Map.Entry<DiscoveryNode, TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> nodeStoreEntry : data.getData().entrySet()) {
            Decision decision;
            RoutingNode node;
            DiscoveryNode discoNode = nodeStoreEntry.getKey();
            TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData = nodeStoreEntry.getValue().storeFilesMetaData();
            if (storeFilesMetaData == null || (node = allocation.routingNodes().node(discoNode.id())) == null || (decision = allocation.deciders().canAllocate(shard, node, allocation)).type() == Decision.Type.NO || storeFilesMetaData.allocated() || !storeFilesMetaData.iterator().hasNext()) continue;
            String primarySyncId = primaryStore.syncId();
            String replicaSyncId = storeFilesMetaData.syncId();
            if (replicaSyncId != null && replicaSyncId.equals(primarySyncId)) {
                this.logger.trace("{}: node [{}] has same sync id {} as primary", shard, discoNode.name(), replicaSyncId);
                nodesToSize.put((Object)discoNode, Long.MAX_VALUE);
                continue;
            }
            long sizeMatched = 0L;
            for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
                String metaDataFileName = storeFileMetaData.name();
                if (!primaryStore.fileExists(metaDataFileName) || !primaryStore.file(metaDataFileName).isSame(storeFileMetaData)) continue;
                sizeMatched += storeFileMetaData.length();
            }
            this.logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable data", shard, discoNode.name(), new ByteSizeValue(sizeMatched), sizeMatched);
            nodesToSize.put((Object)discoNode, sizeMatched);
        }
        return new MatchingNodes((ObjectLongMap<DiscoveryNode>)nodesToSize);
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetchData(ShardRouting var1, RoutingAllocation var2);

    static class MatchingNodes {
        private final ObjectLongMap<DiscoveryNode> nodesToSize;
        private final DiscoveryNode nodeWithHighestMatch;

        public MatchingNodes(ObjectLongMap<DiscoveryNode> nodesToSize) {
            this.nodesToSize = nodesToSize;
            long highestMatchSize = 0L;
            DiscoveryNode highestMatchNode = null;
            for (ObjectLongCursor cursor : nodesToSize) {
                if (cursor.value <= highestMatchSize) continue;
                highestMatchSize = cursor.value;
                highestMatchNode = (DiscoveryNode)cursor.key;
            }
            this.nodeWithHighestMatch = highestMatchNode;
        }

        @Nullable
        public DiscoveryNode getNodeWithHighestMatch() {
            return this.nodeWithHighestMatch;
        }

        public boolean isNodeMatchBySyncID(DiscoveryNode node) {
            return this.nodesToSize.get((Object)node) == Long.MAX_VALUE;
        }

        public boolean hasAnyData() {
            return !this.nodesToSize.isEmpty();
        }
    }
}

