"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

Object.defineProperty(exports, "__esModule", {
    value: true
});
/*
  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

var Syntax = require("estraverse").Syntax;

var Map = _interopRequire(require("es6-map"));

var Reference = _interopRequire(require("./reference"));

var Variable = _interopRequire(require("./variable"));

var Definition = _interopRequire(require("./definition"));

var assert = _interopRequire(require("assert"));

function isStrictScope(scope, block, isMethodDefinition, useDirective) {
    var body, i, iz, stmt, expr;

    // When upper scope is exists and strict, inner scope is also strict.
    if (scope.upper && scope.upper.isStrict) {
        return true;
    }

    // ArrowFunctionExpression's scope is always strict scope.
    if (block.type === Syntax.ArrowFunctionExpression) {
        return true;
    }

    if (isMethodDefinition) {
        return true;
    }

    if (scope.type === "class" || scope.type === "module") {
        return true;
    }

    if (scope.type === "block" || scope.type === "switch") {
        return false;
    }

    if (scope.type === "function") {
        if (block.type === Syntax.Program) {
            body = block;
        } else {
            body = block.body;
        }
    } else if (scope.type === "global") {
        body = block;
    } else {
        return false;
    }

    // Search 'use strict' directive.
    if (useDirective) {
        for (i = 0, iz = body.body.length; i < iz; ++i) {
            stmt = body.body[i];
            if (stmt.type !== Syntax.DirectiveStatement) {
                break;
            }
            if (stmt.raw === "\"use strict\"" || stmt.raw === "'use strict'") {
                return true;
            }
        }
    } else {
        for (i = 0, iz = body.body.length; i < iz; ++i) {
            stmt = body.body[i];
            if (stmt.type !== Syntax.ExpressionStatement) {
                break;
            }
            expr = stmt.expression;
            if (expr.type !== Syntax.Literal || typeof expr.value !== "string") {
                break;
            }
            if (expr.raw != null) {
                if (expr.raw === "\"use strict\"" || expr.raw === "'use strict'") {
                    return true;
                }
            } else {
                if (expr.value === "use strict") {
                    return true;
                }
            }
        }
    }
    return false;
}

function registerScope(scopeManager, scope) {
    var scopes;

    scopeManager.scopes.push(scope);

    scopes = scopeManager.__nodeToScope.get(scope.block);
    if (scopes) {
        scopes.push(scope);
    } else {
        scopeManager.__nodeToScope.set(scope.block, [scope]);
    }
}

function shouldBeStatically(def) {
    return def.type === Variable.ClassName || def.type === Variable.Variable && def.parent.kind !== "var";
}

/**
 * @class Scope
 */

var Scope = (function () {
    function Scope(scopeManager, type, upperScope, block, isMethodDefinition) {
        _classCallCheck(this, Scope);

        /**
         * One of 'TDZ', 'module', 'block', 'switch', 'function', 'catch', 'with', 'function', 'class', 'global'.
         * @member {String} Scope#type
         */
        this.type = type;
        /**
        * The scoped {@link Variable}s of this scope, as <code>{ Variable.name
        * : Variable }</code>.
        * @member {Map} Scope#set
        */
        this.set = new Map();
        /**
         * The tainted variables of this scope, as <code>{ Variable.name :
         * boolean }</code>.
         * @member {Map} Scope#taints */
        this.taints = new Map();
        /**
         * Generally, through the lexical scoping of JS you can always know
         * which variable an identifier in the source code refers to. There are
         * a few exceptions to this rule. With 'global' and 'with' scopes you
         * can only decide at runtime which variable a reference refers to.
         * Moreover, if 'eval()' is used in a scope, it might introduce new
         * bindings in this or its parent scopes.
         * All those scopes are considered 'dynamic'.
         * @member {boolean} Scope#dynamic
         */
        this.dynamic = this.type === "global" || this.type === "with";
        /**
         * A reference to the scope-defining syntax node.
         * @member {esprima.Node} Scope#block
         */
        this.block = block;
        /**
        * The {@link Reference|references} that are not resolved with this scope.
        * @member {Reference[]} Scope#through
        */
        this.through = [];
        /**
        * The scoped {@link Variable}s of this scope. In the case of a
        * 'function' scope this includes the automatic argument <em>arguments</em> as
        * its first element, as well as all further formal arguments.
        * @member {Variable[]} Scope#variables
        */
        this.variables = [];
        /**
        * Any variable {@link Reference|reference} found in this scope. This
        * includes occurrences of local variables as well as variables from
        * parent scopes (including the global scope). For local variables
        * this also includes defining occurrences (like in a 'var' statement).
        * In a 'function' scope this does not include the occurrences of the
        * formal parameter in the parameter list.
        * @member {Reference[]} Scope#references
        */
        this.references = [];

        /**
        * For 'global' and 'function' scopes, this is a self-reference. For
        * other scope types this is the <em>variableScope</em> value of the
        * parent scope.
        * @member {Scope} Scope#variableScope
        */
        this.variableScope = this.type === "global" || this.type === "function" || this.type === "module" ? this : upperScope.variableScope;
        /**
        * Whether this scope is created by a FunctionExpression.
        * @member {boolean} Scope#functionExpressionScope
        */
        this.functionExpressionScope = false;
        /**
        * Whether this is a scope that contains an 'eval()' invocation.
        * @member {boolean} Scope#directCallToEvalScope
        */
        this.directCallToEvalScope = false;
        /**
        * @member {boolean} Scope#thisFound
        */
        this.thisFound = false;

        this.__left = [];

        /**
        * Reference to the parent {@link Scope|scope}.
        * @member {Scope} Scope#upper
        */
        this.upper = upperScope;
        /**
        * Whether 'use strict' is in effect in this scope.
        * @member {boolean} Scope#isStrict
        */
        this.isStrict = isStrictScope(this, block, isMethodDefinition, scopeManager.__useDirective());

        /**
        * List of nested {@link Scope}s.
        * @member {Scope[]} Scope#childScopes
        */
        this.childScopes = [];
        if (this.upper) {
            this.upper.childScopes.push(this);
        }

        this.__declaredVariables = scopeManager.__declaredVariables;

        registerScope(scopeManager, this);
    }

    _createClass(Scope, {
        __shouldStaticallyClose: {
            value: function __shouldStaticallyClose(scopeManager) {
                return !this.dynamic || scopeManager.__isOptimistic();
            }
        },
        __shouldStaticallyCloseForGlobal: {
            value: function __shouldStaticallyCloseForGlobal(ref) {
                // On global scope, let/const/class declarations should be resolved statically.
                var name = ref.identifier.name;
                if (!this.set.has(name)) {
                    return false;
                }

                var variable = this.set.get(name);
                var defs = variable.defs;
                return defs.length > 0 && defs.every(shouldBeStatically);
            }
        },
        __staticCloseRef: {
            value: function __staticCloseRef(ref) {
                if (!this.__resolve(ref)) {
                    this.__delegateToUpperScope(ref);
                }
            }
        },
        __dynamicCloseRef: {
            value: function __dynamicCloseRef(ref) {
                // notify all names are through to global
                var current = this;
                do {
                    current.through.push(ref);
                    current = current.upper;
                } while (current);
            }
        },
        __globalCloseRef: {
            value: function __globalCloseRef(ref) {
                // let/const/class declarations should be resolved statically.
                // others should be resolved dynamically.
                if (this.__shouldStaticallyCloseForGlobal(ref)) {
                    this.__staticCloseRef(ref);
                } else {
                    this.__dynamicCloseRef(ref);
                }
            }
        },
        __close: {
            value: function __close(scopeManager) {
                var closeRef;
                if (this.__shouldStaticallyClose(scopeManager)) {
                    closeRef = this.__staticCloseRef;
                } else if (this.type !== "global") {
                    closeRef = this.__dynamicCloseRef;
                } else {
                    closeRef = this.__globalCloseRef;
                }

                // Try Resolving all references in this scope.
                for (var i = 0, iz = this.__left.length; i < iz; ++i) {
                    var ref = this.__left[i];
                    closeRef.call(this, ref);
                }
                this.__left = null;

                return this.upper;
            }
        },
        __resolve: {
            value: function __resolve(ref) {
                var variable, name;
                name = ref.identifier.name;
                if (this.set.has(name)) {
                    variable = this.set.get(name);
                    variable.references.push(ref);
                    variable.stack = variable.stack && ref.from.variableScope === this.variableScope;
                    if (ref.tainted) {
                        variable.tainted = true;
                        this.taints.set(variable.name, true);
                    }
                    ref.resolved = variable;
                    return true;
                }
                return false;
            }
        },
        __delegateToUpperScope: {
            value: function __delegateToUpperScope(ref) {
                if (this.upper) {
                    this.upper.__left.push(ref);
                }
                this.through.push(ref);
            }
        },
        __addDeclaredVariablesOfNode: {
            value: function __addDeclaredVariablesOfNode(variable, node) {
                if (node == null) {
                    return;
                }

                var variables = this.__declaredVariables.get(node);
                if (variables == null) {
                    variables = [];
                    this.__declaredVariables.set(node, variables);
                }
                if (variables.indexOf(variable) === -1) {
                    variables.push(variable);
                }
            }
        },
        __defineGeneric: {
            value: function __defineGeneric(name, set, variables, node, def) {
                var variable;

                variable = set.get(name);
                if (!variable) {
                    variable = new Variable(name, this);
                    set.set(name, variable);
                    variables.push(variable);
                }

                if (def) {
                    variable.defs.push(def);
                    if (def.type !== Variable.TDZ) {
                        this.__addDeclaredVariablesOfNode(variable, def.node);
                        this.__addDeclaredVariablesOfNode(variable, def.parent);
                    }
                }
                if (node) {
                    variable.identifiers.push(node);
                }
            }
        },
        __define: {
            value: function __define(node, def) {
                if (node && node.type === Syntax.Identifier) {
                    this.__defineGeneric(node.name, this.set, this.variables, node, def);
                }
            }
        },
        __referencing: {
            value: function __referencing(node, assign, writeExpr, maybeImplicitGlobal, partial, init) {
                // because Array element may be null
                if (!node || node.type !== Syntax.Identifier) {
                    return;
                }

                // Specially handle like `this`.
                if (node.name === "super") {
                    return;
                }

                var ref = new Reference(node, this, assign || Reference.READ, writeExpr, maybeImplicitGlobal, !!partial, !!init);
                this.references.push(ref);
                this.__left.push(ref);
            }
        },
        __detectEval: {
            value: function __detectEval() {
                var current;
                current = this;
                this.directCallToEvalScope = true;
                do {
                    current.dynamic = true;
                    current = current.upper;
                } while (current);
            }
        },
        __detectThis: {
            value: function __detectThis() {
                this.thisFound = true;
            }
        },
        __isClosed: {
            value: function __isClosed() {
                return this.__left === null;
            }
        },
        resolve: {

            /**
             * returns resolved {Reference}
             * @method Scope#resolve
             * @param {Esprima.Identifier} ident - identifier to be resolved.
             * @return {Reference}
             */

            value: function resolve(ident) {
                var ref, i, iz;
                assert(this.__isClosed(), "Scope should be closed.");
                assert(ident.type === Syntax.Identifier, "Target should be identifier.");
                for (i = 0, iz = this.references.length; i < iz; ++i) {
                    ref = this.references[i];
                    if (ref.identifier === ident) {
                        return ref;
                    }
                }
                return null;
            }
        },
        isStatic: {

            /**
             * returns this scope is static
             * @method Scope#isStatic
             * @return {boolean}
             */

            value: function isStatic() {
                return !this.dynamic;
            }
        },
        isArgumentsMaterialized: {

            /**
             * returns this scope has materialized arguments
             * @method Scope#isArgumentsMaterialized
             * @return {boolean}
             */

            value: function isArgumentsMaterialized() {
                return true;
            }
        },
        isThisMaterialized: {

            /**
             * returns this scope has materialized `this` reference
             * @method Scope#isThisMaterialized
             * @return {boolean}
             */

            value: function isThisMaterialized() {
                return true;
            }
        },
        isUsedName: {
            value: function isUsedName(name) {
                if (this.set.has(name)) {
                    return true;
                }
                for (var i = 0, iz = this.through.length; i < iz; ++i) {
                    if (this.through[i].identifier.name === name) {
                        return true;
                    }
                }
                return false;
            }
        }
    });

    return Scope;
})();

exports["default"] = Scope;

var GlobalScope = exports.GlobalScope = (function (_Scope) {
    function GlobalScope(scopeManager, block) {
        _classCallCheck(this, GlobalScope);

        _get(Object.getPrototypeOf(GlobalScope.prototype), "constructor", this).call(this, scopeManager, "global", null, block, false);
        this.implicit = {
            set: new Map(),
            variables: [],
            /**
            * List of {@link Reference}s that are left to be resolved (i.e. which
            * need to be linked to the variable they refer to).
            * @member {Reference[]} Scope#implicit#left
            */
            left: []
        };
    }

    _inherits(GlobalScope, _Scope);

    _createClass(GlobalScope, {
        __close: {
            value: function __close(scopeManager) {
                var implicit = [];
                for (var i = 0, iz = this.__left.length; i < iz; ++i) {
                    var ref = this.__left[i];
                    if (ref.__maybeImplicitGlobal && !this.set.has(ref.identifier.name)) {
                        implicit.push(ref.__maybeImplicitGlobal);
                    }
                }

                // create an implicit global variable from assignment expression
                for (var i = 0, iz = implicit.length; i < iz; ++i) {
                    var info = implicit[i];
                    this.__defineImplicit(info.pattern, new Definition(Variable.ImplicitGlobalVariable, info.pattern, info.node, null, null, null));
                }

                this.implicit.left = this.__left;

                return _get(Object.getPrototypeOf(GlobalScope.prototype), "__close", this).call(this, scopeManager);
            }
        },
        __defineImplicit: {
            value: function __defineImplicit(node, def) {
                if (node && node.type === Syntax.Identifier) {
                    this.__defineGeneric(node.name, this.implicit.set, this.implicit.variables, node, def);
                }
            }
        }
    });

    return GlobalScope;
})(Scope);

var ModuleScope = exports.ModuleScope = (function (_Scope2) {
    function ModuleScope(scopeManager, upperScope, block) {
        _classCallCheck(this, ModuleScope);

        _get(Object.getPrototypeOf(ModuleScope.prototype), "constructor", this).call(this, scopeManager, "module", upperScope, block, false);
    }

    _inherits(ModuleScope, _Scope2);

    return ModuleScope;
})(Scope);

var FunctionExpressionNameScope = exports.FunctionExpressionNameScope = (function (_Scope3) {
    function FunctionExpressionNameScope(scopeManager, upperScope, block) {
        _classCallCheck(this, FunctionExpressionNameScope);

        _get(Object.getPrototypeOf(FunctionExpressionNameScope.prototype), "constructor", this).call(this, scopeManager, "function-expression-name", upperScope, block, false);
        this.__define(block.id, new Definition(Variable.FunctionName, block.id, block, null, null, null));
        this.functionExpressionScope = true;
    }

    _inherits(FunctionExpressionNameScope, _Scope3);

    return FunctionExpressionNameScope;
})(Scope);

var CatchScope = exports.CatchScope = (function (_Scope4) {
    function CatchScope(scopeManager, upperScope, block) {
        _classCallCheck(this, CatchScope);

        _get(Object.getPrototypeOf(CatchScope.prototype), "constructor", this).call(this, scopeManager, "catch", upperScope, block, false);
    }

    _inherits(CatchScope, _Scope4);

    return CatchScope;
})(Scope);

var WithScope = exports.WithScope = (function (_Scope5) {
    function WithScope(scopeManager, upperScope, block) {
        _classCallCheck(this, WithScope);

        _get(Object.getPrototypeOf(WithScope.prototype), "constructor", this).call(this, scopeManager, "with", upperScope, block, false);
    }

    _inherits(WithScope, _Scope5);

    _createClass(WithScope, {
        __close: {
            value: function __close(scopeManager) {
                if (this.__shouldStaticallyClose(scopeManager)) {
                    return _get(Object.getPrototypeOf(WithScope.prototype), "__close", this).call(this, scopeManager);
                }

                for (var i = 0, iz = this.__left.length; i < iz; ++i) {
                    var ref = this.__left[i];
                    ref.tainted = true;
                    this.__delegateToUpperScope(ref);
                }
                this.__left = null;

                return this.upper;
            }
        }
    });

    return WithScope;
})(Scope);

var TDZScope = exports.TDZScope = (function (_Scope6) {
    function TDZScope(scopeManager, upperScope, block) {
        _classCallCheck(this, TDZScope);

        _get(Object.getPrototypeOf(TDZScope.prototype), "constructor", this).call(this, scopeManager, "TDZ", upperScope, block, false);
    }

    _inherits(TDZScope, _Scope6);

    return TDZScope;
})(Scope);

var BlockScope = exports.BlockScope = (function (_Scope7) {
    function BlockScope(scopeManager, upperScope, block) {
        _classCallCheck(this, BlockScope);

        _get(Object.getPrototypeOf(BlockScope.prototype), "constructor", this).call(this, scopeManager, "block", upperScope, block, false);
    }

    _inherits(BlockScope, _Scope7);

    return BlockScope;
})(Scope);

var SwitchScope = exports.SwitchScope = (function (_Scope8) {
    function SwitchScope(scopeManager, upperScope, block) {
        _classCallCheck(this, SwitchScope);

        _get(Object.getPrototypeOf(SwitchScope.prototype), "constructor", this).call(this, scopeManager, "switch", upperScope, block, false);
    }

    _inherits(SwitchScope, _Scope8);

    return SwitchScope;
})(Scope);

var FunctionScope = exports.FunctionScope = (function (_Scope9) {
    function FunctionScope(scopeManager, upperScope, block, isMethodDefinition) {
        _classCallCheck(this, FunctionScope);

        _get(Object.getPrototypeOf(FunctionScope.prototype), "constructor", this).call(this, scopeManager, "function", upperScope, block, isMethodDefinition);

        // section 9.2.13, FunctionDeclarationInstantiation.
        // NOTE Arrow functions never have an arguments objects.
        if (this.block.type !== Syntax.ArrowFunctionExpression) {
            this.__defineArguments();
        }
    }

    _inherits(FunctionScope, _Scope9);

    _createClass(FunctionScope, {
        isArgumentsMaterialized: {
            value: function isArgumentsMaterialized() {
                // TODO(Constellation)
                // We can more aggressive on this condition like this.
                //
                // function t() {
                //     // arguments of t is always hidden.
                //     function arguments() {
                //     }
                // }
                if (this.block.type === Syntax.ArrowFunctionExpression) {
                    return false;
                }

                if (!this.isStatic()) {
                    return true;
                }

                var variable = this.set.get("arguments");
                assert(variable, "Always have arguments variable.");
                return variable.tainted || variable.references.length !== 0;
            }
        },
        isThisMaterialized: {
            value: function isThisMaterialized() {
                if (!this.isStatic()) {
                    return true;
                }
                return this.thisFound;
            }
        },
        __defineArguments: {
            value: function __defineArguments() {
                this.__defineGeneric("arguments", this.set, this.variables, null, null);
                this.taints.set("arguments", true);
            }
        }
    });

    return FunctionScope;
})(Scope);

var ForScope = exports.ForScope = (function (_Scope10) {
    function ForScope(scopeManager, upperScope, block) {
        _classCallCheck(this, ForScope);

        _get(Object.getPrototypeOf(ForScope.prototype), "constructor", this).call(this, scopeManager, "for", upperScope, block, false);
    }

    _inherits(ForScope, _Scope10);

    return ForScope;
})(Scope);

var ClassScope = exports.ClassScope = (function (_Scope11) {
    function ClassScope(scopeManager, upperScope, block) {
        _classCallCheck(this, ClassScope);

        _get(Object.getPrototypeOf(ClassScope.prototype), "constructor", this).call(this, scopeManager, "class", upperScope, block, false);
    }

    _inherits(ClassScope, _Scope11);

    return ClassScope;
})(Scope);

/* vim: set sw=4 ts=4 et tw=80 : */
//# sourceMappingURL=data:application/json;base64,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
