/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation.favorites;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gradle.foundation.CommandLineAssistant;
import org.gradle.foundation.TaskView;
import org.gradle.foundation.common.ObserverLord;
import org.gradle.foundation.common.ReorderableList;
import org.gradle.gradleplugin.foundation.DOM4JSerializer;
import org.gradle.gradleplugin.foundation.ExtensionFileFilter;
import org.gradle.gradleplugin.foundation.favorites.FavoriteTask;
import org.gradle.gradleplugin.foundation.favorites.FavoritesSerializable;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.foundation.settings.SettingsSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesEditor
implements SettingsSerializable {
    private ReorderableList<FavoriteTask> favoriteTasks = new ReorderableList();
    private ObserverLord<FavoriteTasksObserver> favoriteTasksObserverLord = new ObserverLord();

    public List<FavoriteTask> getFavoriteTasks() {
        return Collections.unmodifiableList(this.favoriteTasks);
    }

    public void addFavoriteTasksObserver(FavoriteTasksObserver observer, boolean inEventQueue) {
        this.favoriteTasksObserverLord.addObserver(observer, inEventQueue);
    }

    public void removeFavoriteTasksObserver(FavoriteTasksObserver observer) {
        this.favoriteTasksObserverLord.removeObserver(observer);
    }

    public FavoriteTask getFavorite(String fullCommandLine) {
        for (FavoriteTask favoriteTask : this.favoriteTasks) {
            if (!fullCommandLine.equals(favoriteTask.getFullCommandLine())) continue;
            return favoriteTask;
        }
        return null;
    }

    public FavoriteTask getFavoriteByDisplayName(String displayName) {
        for (FavoriteTask favoriteTask : this.favoriteTasks) {
            if (!displayName.equals(favoriteTask.getDisplayName())) continue;
            return favoriteTask;
        }
        return null;
    }

    public FavoriteTask getFavorite(TaskView task) {
        return this.getFavorite(task.getFullTaskName());
    }

    private void notifyFavoritesChanged() {
        this.favoriteTasksObserverLord.notifyObservers(new ObserverLord.ObserverNotification<FavoriteTasksObserver>(){

            @Override
            public void notify(FavoriteTasksObserver observer) {
                observer.favoritesChanged();
            }
        });
    }

    public void addMutlipleFavorites(List<TaskView> tasks, boolean alwaysShowOutput, AddMultipleFavoritesInteraction interaction) {
        if (tasks.isEmpty()) {
            return;
        }
        if (tasks.size() == 1) {
            this.addFavorite(tasks.get(0), alwaysShowOutput);
            return;
        }
        String singleCommandLine = CommandLineAssistant.combineTasks(tasks, new String[0]);
        AddMultipleResult addMultipleResult = interaction.promptUserToCombineTasks(tasks, singleCommandLine);
        switch (addMultipleResult) {
            case Cancel: {
                return;
            }
            case AddSeparately: {
                for (TaskView task : tasks) {
                    this.addFavorite(task, alwaysShowOutput);
                }
                break;
            }
            case AddAsSingleCommand: {
                this.addFavorite(singleCommandLine, alwaysShowOutput);
            }
        }
    }

    public FavoriteTask addFavorite(TaskView task, boolean alwaysShowOutput) {
        return this.addFavorite(task.getFullTaskName(), alwaysShowOutput);
    }

    public FavoriteTask addFavorite(String fullCommandLine, boolean alwaysShowOutput) {
        FavoriteTask favorite = this.addFavorite(fullCommandLine, fullCommandLine, alwaysShowOutput);
        if (favorite != null) {
            this.notifyFavoritesChanged();
        }
        return favorite;
    }

    public FavoriteTask addFavorite(String fullCommandLine, String displayName, boolean alwaysShowOutput) {
        if ((fullCommandLine == null || fullCommandLine.trim().equals("")) && (displayName == null || displayName.trim().equals(""))) {
            return null;
        }
        FavoriteTask favoriteTask = new FavoriteTask(fullCommandLine, displayName, alwaysShowOutput);
        this.favoriteTasks.add(favoriteTask);
        return favoriteTask;
    }

    public void addFavorites(List<TaskView> tasks, boolean alwaysShowOutput) {
        boolean addedFavorite = false;
        for (TaskView task : tasks) {
            String fullTaskName = task.getFullTaskName();
            if (this.addFavorite(fullTaskName, alwaysShowOutput) == null) continue;
            addedFavorite = true;
        }
        if (addedFavorite) {
            this.favoriteTasksObserverLord.notifyObservers(new ObserverLord.ObserverNotification<FavoriteTasksObserver>(){

                @Override
                public void notify(FavoriteTasksObserver observer) {
                    observer.favoritesChanged();
                }
            });
        }
    }

    public FavoriteTask addFavorite(EditFavoriteInteraction addFavoriteInteraction) {
        FavoriteTask newFavorite = new FavoriteTask("", "", false);
        if (!this.editInternal(newFavorite, addFavoriteInteraction)) {
            return null;
        }
        this.favoriteTasks.add(newFavorite);
        this.notifyFavoritesChanged();
        return newFavorite;
    }

    public boolean editFavorite(FavoriteTask favoriteTask, EditFavoriteInteraction editFavoriteInteraction) {
        if (favoriteTask == null) {
            return false;
        }
        if (this.favoriteTasks.indexOf(favoriteTask) == -1) {
            return false;
        }
        if (!this.editInternal(favoriteTask, editFavoriteInteraction)) {
            return false;
        }
        this.notifyFavoritesChanged();
        return true;
    }

    private boolean editInternal(FavoriteTask favoriteTask, EditFavoriteInteraction editFavoriteInteraction) {
        EditibleFavoriteTask workingCopy = new EditibleFavoriteTask(favoriteTask);
        boolean isValid = true;
        do {
            if (editFavoriteInteraction.editFavorite(workingCopy)) continue;
            return false;
        } while (!(isValid = this.validateEditableFavoriteTask(workingCopy, favoriteTask, editFavoriteInteraction)));
        favoriteTask.setFullCommandLine(workingCopy.fullCommandLine);
        favoriteTask.setDisplayName(workingCopy.displayName);
        favoriteTask.setAlwaysShowOutput(workingCopy.alwaysShowOutput);
        return true;
    }

    private boolean validateEditableFavoriteTask(EditibleFavoriteTask editibleFavoriteTask, FavoriteTask originalFavoriteTaskObject, ValidationInteraction validationInteraction) {
        if (editibleFavoriteTask.fullCommandLine == null || editibleFavoriteTask.fullCommandLine.trim().equals("")) {
            validationInteraction.reportError("Full task name must be specified");
            return false;
        }
        if (editibleFavoriteTask.displayName == null || editibleFavoriteTask.displayName.trim().equals("")) {
            validationInteraction.reportError("Display name must be specified");
            return false;
        }
        return true;
    }

    public void removeFavorites(List<FavoriteTask> favoritesToRemove) {
        if (this.favoriteTasks.removeAll(favoritesToRemove)) {
            this.notifyFavoritesChanged();
        }
    }

    public void moveFavoritesBefore(List<FavoriteTask> favoritesToMove) {
        this.moveFavorites(favoritesToMove, true);
    }

    public void moveFavoritesAfter(List<FavoriteTask> favoritesToMove) {
        this.moveFavorites(favoritesToMove, false);
    }

    private void moveFavorites(List<FavoriteTask> favoritesToMove, boolean moveBefore) {
        if (moveBefore) {
            this.favoriteTasks.moveBefore(favoritesToMove);
        } else {
            this.favoriteTasks.moveAfter(favoritesToMove);
        }
        this.favoriteTasksObserverLord.notifyObservers(new ObserverLord.ObserverNotification<FavoriteTasksObserver>(){

            @Override
            public void notify(FavoriteTasksObserver observer) {
                observer.favoritesReordered(FavoritesEditor.this.favoriteTasks);
            }
        });
    }

    public void exportToFile(DOM4JSerializer.ExportInteraction exportInteraction) {
        DOM4JSerializer.exportToFile("favorites", exportInteraction, this.createFileFilter(), this);
    }

    public boolean importFromFile(DOM4JSerializer.ImportInteraction importInteraction) {
        FavoritesSerializable serializable = new FavoritesSerializable();
        if (!DOM4JSerializer.importFromFile(importInteraction, this.createFileFilter(), serializable)) {
            return false;
        }
        this.favoriteTasks.clear();
        this.favoriteTasks.addAll(serializable.getFavorites());
        this.notifyFavoritesChanged();
        return true;
    }

    private ExtensionFileFilter createFileFilter() {
        return new ExtensionFileFilter(".favorite-tasks", "Favorite Tasks");
    }

    @Override
    public void serializeOut(SettingsNode settings) {
        FavoritesSerializable.serializeOut(settings, this.favoriteTasks);
    }

    @Override
    public void serializeIn(SettingsNode settings) {
        FavoritesSerializable.serializeIn(settings, this.favoriteTasks);
    }

    public void duplicateFavorites(List<FavoriteTask> tasksToCopy, EditFavoriteInteraction editFavoriteInteraction) {
        if (tasksToCopy == null || tasksToCopy.isEmpty()) {
            return;
        }
        for (FavoriteTask taskToCopy : tasksToCopy) {
            FavoriteTask newFavoriteTask = new FavoriteTask(taskToCopy.getFullCommandLine(), taskToCopy.getDisplayName(), taskToCopy.alwaysShowOutput());
            if (!this.editInternal(newFavoriteTask, editFavoriteInteraction)) {
                return;
            }
            this.favoriteTasks.add(newFavoriteTask);
        }
        this.notifyFavoritesChanged();
    }

    public FavoriteTask duplicateFavorite(FavoriteTask taskToCopy, EditFavoriteInteraction editFavoriteInteraction) {
        if (taskToCopy == null) {
            return null;
        }
        FavoriteTask newFavoriteTask = new FavoriteTask(taskToCopy.getFullCommandLine(), taskToCopy.getDisplayName(), taskToCopy.alwaysShowOutput());
        if (!this.editInternal(newFavoriteTask, editFavoriteInteraction)) {
            return null;
        }
        this.favoriteTasks.add(newFavoriteTask);
        this.notifyFavoritesChanged();
        return newFavoriteTask;
    }

    public static String combineFavoriteCommandLines(List<FavoriteTask> favoriteTasks) {
        StringBuilder builder = new StringBuilder();
        Iterator<FavoriteTask> iterator = favoriteTasks.iterator();
        while (iterator.hasNext()) {
            FavoriteTask favoriteTask = iterator.next();
            builder.append(favoriteTask.getFullCommandLine());
            if (!iterator.hasNext()) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public static interface ValidationInteraction {
        public void reportError(String var1);
    }

    public static interface EditFavoriteInteraction
    extends ValidationInteraction {
        public boolean editFavorite(EditibleFavoriteTask var1);
    }

    public class EditibleFavoriteTask {
        public String fullCommandLine;
        public String displayName;
        public boolean alwaysShowOutput;

        public EditibleFavoriteTask(FavoriteTask favoriteTask) {
            this(favoriteTask.getFullCommandLine(), favoriteTask.getDisplayName(), favoriteTask.alwaysShowOutput());
        }

        public EditibleFavoriteTask(String fullCommandLine, String displayName, boolean alwaysShowOutput) {
            this.fullCommandLine = fullCommandLine;
            this.displayName = displayName;
            this.alwaysShowOutput = alwaysShowOutput;
        }

        public boolean isDisplayNameAndFullCommandSynchronized() {
            if (this.displayName == null) {
                return this.fullCommandLine == null;
            }
            return this.displayName.equals(this.fullCommandLine);
        }

        public String toString() {
            return this.displayName + " " + this.fullCommandLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AddMultipleFavoritesInteraction {
        public AddMultipleResult promptUserToCombineTasks(List<TaskView> var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddMultipleResult {
        AddSeparately,
        AddAsSingleCommand,
        Cancel;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FavoriteTasksObserver {
        public void favoritesChanged();

        public void favoritesReordered(List<FavoriteTask> var1);
    }
}

