/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.plugins;

import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.model.Defaults;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.plugins.NativeComponentPlugin;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinarySpecInternal;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.test.TestSuiteContainer;
import org.gradle.platform.base.test.TestSuiteSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeBinariesTestPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(NativeComponentPlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        void testSuites(TestSuiteContainer testSuites) {
        }

        @Defaults
        void attachTestedBinarySourcesToTestBinaries(ModelMap<BinarySpec> binaries) {
            binaries.withType(NativeTestSuiteBinarySpecInternal.class).afterEach((Action)new Action<NativeTestSuiteBinarySpecInternal>(){

                public void execute(NativeTestSuiteBinarySpecInternal testSuiteBinary) {
                    NativeBinarySpec testedBinary = testSuiteBinary.getTestedBinary();
                    for (DependentSourceSet testSource : testSuiteBinary.getInputs().withType(DependentSourceSet.class)) {
                        testSource.lib(testedBinary.getInputs());
                    }
                    testSuiteBinary.getInputs().addAll((Collection)testedBinary.getInputs());
                }
            });
        }

        @Mutate
        public void createTestTasks(TaskContainer tasks, ModelMap<NativeTestSuiteBinarySpec> binaries) {
            for (NativeTestSuiteBinarySpec testBinary : binaries) {
                NativeBinarySpecInternal binary = (NativeBinarySpecInternal)((Object)testBinary);
                BinaryNamingScheme namingScheme = binary.getNamingScheme();
                RunTestExecutable runTask = (RunTestExecutable)tasks.create(namingScheme.getTaskName("run"), RunTestExecutable.class);
                Project project = runTask.getProject();
                runTask.setDescription(String.format("Runs the %s", binary));
                InstallExecutable installTask = (InstallExecutable)((Object)binary.getTasks().withType(InstallExecutable.class).iterator().next());
                runTask.getInputs().files(new Object[]{installTask.getOutputs().getFiles()});
                runTask.setExecutable(installTask.getRunScript().getPath());
                runTask.setOutputDir(namingScheme.getOutputDirectory(project.getBuildDir(), "test-results"));
                testBinary.getTasks().add((Object)runTask);
            }
        }

        @Defaults
        public void copyTestBinariesToGlobalContainer(ModelMap<BinarySpec> binaries, TestSuiteContainer testSuites) {
            for (TestSuiteSpec testSuite : testSuites.withType(TestSuiteSpec.class).values()) {
                for (BinarySpec binary : testSuite.getBinaries().values()) {
                    binaries.put(((BinarySpecInternal)binary).getProjectScopedName(), (Object)binary);
                }
            }
        }

        @Mutate
        void attachBinariesToCheckLifecycle(ModelMap<Task> tasks, final ModelMap<NativeTestSuiteBinarySpec> binaries) {
            tasks.named("check", (Action)new Action<Task>(){

                public void execute(Task checkTask) {
                    for (NativeTestSuiteBinarySpec testBinary : binaries) {
                        checkTask.dependsOn(new Object[]{testBinary.getTasks().getRun()});
                    }
                }
            });
        }
    }
}

