/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashMap;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.OutputFilesCollectionSnapshotter;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutputFilesSnapshotSerializer
implements Serializer<OutputFilesCollectionSnapshotter.OutputFilesSnapshot> {
    private final Serializer<FileCollectionSnapshot> serializer;
    private final StringInterner stringInterner;

    public OutputFilesSnapshotSerializer(Serializer<FileCollectionSnapshot> serializer, StringInterner stringInterner) {
        this.serializer = serializer;
        this.stringInterner = stringInterner;
    }

    public OutputFilesCollectionSnapshotter.OutputFilesSnapshot read(Decoder decoder) throws Exception {
        HashMap<String, Long> rootFileIds = new HashMap<String, Long>();
        int rootFileIdsCount = decoder.readSmallInt();
        for (int i = 0; i < rootFileIdsCount; ++i) {
            String key = this.stringInterner.intern(decoder.readString());
            boolean notNull = decoder.readBoolean();
            Long value = notNull ? Long.valueOf(decoder.readLong()) : null;
            rootFileIds.put(key, value);
        }
        FileCollectionSnapshot snapshot = (FileCollectionSnapshot)this.serializer.read(decoder);
        return new OutputFilesCollectionSnapshotter.OutputFilesSnapshot(rootFileIds, snapshot);
    }

    public void write(Encoder encoder, OutputFilesCollectionSnapshotter.OutputFilesSnapshot value) throws Exception {
        int rootFileIds = value.rootFileIds.size();
        encoder.writeSmallInt(rootFileIds);
        for (String key : value.rootFileIds.keySet()) {
            Long id = value.rootFileIds.get(key);
            encoder.writeString((CharSequence)key);
            if (id == null) {
                encoder.writeBoolean(false);
                continue;
            }
            encoder.writeBoolean(true);
            encoder.writeLong(id.longValue());
        }
        this.serializer.write(encoder, (Object)value.filesSnapshot);
    }
}

