/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.LocalFileTree;
import org.gradle.api.internal.file.collections.MapFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeAdapter
extends AbstractFileTree
implements FileCollectionContainer {
    private final MinimalFileTree tree;

    public FileTreeAdapter(MinimalFileTree tree) {
        this.tree = tree;
    }

    public MinimalFileTree getTree() {
        return this.tree;
    }

    @Override
    public String getDisplayName() {
        return this.tree.getDisplayName();
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        context.add(this.tree);
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        this.tree.registerWatchPoints(builder);
    }

    @Override
    protected Collection<DirectoryFileTree> getAsFileTrees() {
        if (this.tree instanceof FileSystemMirroringFileTree) {
            FileSystemMirroringFileTree mirroringTree = (FileSystemMirroringFileTree)this.tree;
            if (this.visitAll()) {
                return Collections.singletonList(mirroringTree.getMirror());
            }
            return Collections.emptyList();
        }
        if (this.tree instanceof LocalFileTree) {
            LocalFileTree fileTree = (LocalFileTree)this.tree;
            return fileTree.getLocalContents();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert %s to local file system directories.", this.tree));
    }

    @Override
    public TaskDependency getBuildDependencies() {
        if (this.tree instanceof Buildable) {
            Buildable buildable = (Buildable)((Object)this.tree);
            return buildable.getBuildDependencies();
        }
        return super.getBuildDependencies();
    }

    @Override
    public boolean contains(File file) {
        if (this.tree instanceof RandomAccessFileCollection) {
            RandomAccessFileCollection randomAccess = (RandomAccessFileCollection)((Object)this.tree);
            return randomAccess.contains(file);
        }
        if (this.tree instanceof MapFileTree) {
            return ((MapFileTree)this.tree).getFilesWithoutCreating().contains(file);
        }
        if (this.tree instanceof FileSystemMirroringFileTree) {
            return ((FileSystemMirroringFileTree)this.tree).getMirror().contains(file);
        }
        return super.contains(file);
    }

    @Override
    public FileTree matching(PatternFilterable patterns) {
        if (this.tree instanceof PatternFilterableFileTree) {
            PatternFilterableFileTree filterableTree = (PatternFilterableFileTree)this.tree;
            return new FileTreeAdapter(filterableTree.filter(patterns));
        }
        return super.matching(patterns);
    }

    @Override
    public FileTree visit(FileVisitor visitor) {
        this.tree.visit(visitor);
        return this;
    }
}

