/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.ImperativeOnlyPluginApplicator;
import org.gradle.api.internal.plugins.PluginApplicator;
import org.gradle.api.internal.plugins.PluginAwareInternal;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.ModelRegistryScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedPluginApplicator<T extends ModelRegistryScope & PluginAwareInternal>
implements PluginApplicator {
    private final T target;
    private final PluginApplicator imperativeApplicator;
    private final ModelRuleExtractor ruleInspector;
    private final ModelRuleSourceDetector ruleDetector;

    public RuleBasedPluginApplicator(T target, ModelRuleExtractor ruleInspector, ModelRuleSourceDetector ruleDetector) {
        this.target = target;
        this.ruleInspector = ruleInspector;
        this.ruleDetector = ruleDetector;
        this.imperativeApplicator = new ImperativeOnlyPluginApplicator<T>(target);
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        this.imperativeApplicator.applyImperative(pluginId, plugin);
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        ModelRegistry modelRegistry = this.target.getModelRegistry();
        Iterable declaredSources = this.ruleDetector.getDeclaredSources(clazz);
        for (Class ruleSource : declaredSources) {
            Iterable rules = this.ruleInspector.extract(ruleSource);
            for (ExtractedModelRule rule : rules) {
                for (Class dependency : rule.getRuleDependencies()) {
                    ((PluginAwareInternal)this.target).getPluginManager().apply(dependency);
                }
                rule.apply(modelRegistry, ModelPath.ROOT);
            }
        }
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin) {
        this.applyImperative(pluginId, plugin);
        this.applyRules(pluginId, plugin.getClass());
    }
}

