/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class TypeCompatibilityModelProjectionSupport<M>
implements ModelProjection {
    private final ModelType<M> type;
    private final boolean canBeViewedAsImmutable;
    private final boolean canBeViewedAsMutable;

    public TypeCompatibilityModelProjectionSupport(ModelType<M> type, boolean canBeViewedAsImmutable, boolean canBeViewedAsMutable) {
        this.type = type;
        this.canBeViewedAsImmutable = canBeViewedAsImmutable;
        this.canBeViewedAsMutable = canBeViewedAsMutable;
    }

    protected ModelType<M> getType() {
        return this.type;
    }

    @Override
    public <T> boolean canBeViewedAsMutable(ModelType<T> targetType) {
        return this.canBeViewedAsMutable && this.canBeAssignedTo(targetType);
    }

    private <T> boolean canBeAssignedTo(ModelType<T> targetType) {
        return targetType.isAssignableFrom(this.type) || targetType == ModelType.UNTYPED && this.type.getRawClass().isPrimitive();
    }

    @Override
    public <T> boolean canBeViewedAsImmutable(ModelType<T> targetType) {
        return this.canBeViewedAsImmutable && this.canBeAssignedTo(targetType);
    }

    @Override
    public <T> ModelView<? extends T> asMutable(ModelType<T> type, MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, List<ModelView<?>> inputs) {
        if (this.canBeViewedAsMutable(type)) {
            return (ModelView)Cast.uncheckedCast(this.toView(modelNode, ruleDescriptor, true));
        }
        return null;
    }

    @Override
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor) {
        if (this.canBeViewedAsImmutable(type)) {
            return (ModelView)Cast.uncheckedCast(this.toView(modelNode, ruleDescriptor, false));
        }
        return null;
    }

    protected abstract ModelView<M> toView(MutableModelNode var1, ModelRuleDescriptor var2, boolean var3);

    @Override
    public Iterable<String> getWritableTypeDescriptions(MutableModelNode node) {
        if (this.canBeViewedAsMutable) {
            return Collections.singleton(TypeCompatibilityModelProjectionSupport.description(this.type));
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<String> getReadableTypeDescriptions(MutableModelNode node) {
        if (this.canBeViewedAsImmutable) {
            return Collections.singleton(TypeCompatibilityModelProjectionSupport.description(this.type));
        }
        return Collections.emptySet();
    }

    public static String description(ModelType<?> type) {
        if (type.getRawClass().getSuperclass() == null && type.getRawClass().getInterfaces().length == 0) {
            return type.toString();
        }
        return type.toString() + " (or assignment compatible type thereof)";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibilityModelProjectionSupport that = (TypeCompatibilityModelProjectionSupport)o;
        return this.canBeViewedAsImmutable == that.canBeViewedAsImmutable && this.canBeViewedAsMutable == that.canBeViewedAsMutable && this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.canBeViewedAsImmutable ? 1 : 0);
        result = 31 * result + (this.canBeViewedAsMutable ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.type + "]";
    }
}

