/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.BuildModelAction;
import org.gradle.tooling.internal.provider.PayloadSerializer;
import org.gradle.tooling.model.internal.ProjectSensitiveToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;

public class BuildModelActionRunner
implements BuildActionRunner {
    public void run(BuildAction action, BuildController buildController) {
        ToolingModelBuilder builder;
        if (!(action instanceof BuildModelAction)) {
            return;
        }
        BuildModelAction buildModelAction = (BuildModelAction)action;
        GradleInternal gradle = buildController.getGradle();
        if (buildModelAction.isRunTasks()) {
            buildController.run();
        } else {
            buildController.configure();
            ((ProjectConfigurer)gradle.getServices().get(ProjectConfigurer.class)).configureHierarchy(gradle.getRootProject());
            for (Project project : gradle.getRootProject().getAllprojects()) {
                ProjectInternal projectInternal = (ProjectInternal)project;
                projectInternal.getTasks().discoverTasks();
                projectInternal.bindAllModelRules();
            }
        }
        String modelName = buildModelAction.getModelName();
        ToolingModelBuilderRegistry builderRegistry = this.getToolingModelBuilderRegistry(gradle);
        try {
            builder = builderRegistry.getBuilder(modelName);
        }
        catch (UnknownModelException e) {
            throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)e);
        }
        Object result = builder instanceof ProjectSensitiveToolingModelBuilder ? ((ProjectSensitiveToolingModelBuilder)builder).buildAll(modelName, (Project)gradle.getDefaultProject(), true) : builder.buildAll(modelName, (Project)gradle.getDefaultProject());
        PayloadSerializer payloadSerializer = (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
        BuildActionResult buildActionResult = new BuildActionResult(payloadSerializer.serialize(result), null);
        buildController.setResult((Object)buildActionResult);
    }

    private ToolingModelBuilderRegistry getToolingModelBuilderRegistry(GradleInternal gradle) {
        return (ToolingModelBuilderRegistry)gradle.getDefaultProject().getServices().get(ToolingModelBuilderRegistry.class);
    }
}

