/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.plugins.antlr.internal.AntlrExecuter;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.api.plugins.antlr.internal.AntlrWorkerClientProtocol;
import org.gradle.process.internal.WorkerProcessContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrWorkerServer
implements Action<WorkerProcessContext>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntlrWorkerServer.class);
    private AntlrSpec spec;

    public AntlrWorkerServer(AntlrSpec spec) {
        this.spec = spec;
    }

    public void execute(WorkerProcessContext context) {
        AntlrResult result = this.execute();
        AntlrWorkerClientProtocol clientProtocol = (AntlrWorkerClientProtocol)context.getServerConnection().addOutgoing(AntlrWorkerClientProtocol.class);
        context.getServerConnection().connect();
        clientProtocol.executed(result);
    }

    public AntlrResult execute() {
        LOGGER.debug("Executing ANTLR worker");
        try {
            AntlrExecuter antlrExecuter = new AntlrExecuter();
            return antlrExecuter.runAntlr(this.spec);
        }
        catch (Exception e) {
            return new AntlrResult(1, e);
        }
    }
}

