/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ErrorHandlingNotationParser<N, T>
implements NotationParser<N, T> {
    private final String targetTypeDisplayName;
    private final String invalidNotationMessage;
    private final boolean allowNullInput;
    private final NotationParser<N, T> delegate;

    public ErrorHandlingNotationParser(String targetTypeDisplayName, String invalidNotationMessage, boolean allowNullInput, NotationParser<N, T> delegate) {
        this.targetTypeDisplayName = targetTypeDisplayName;
        this.invalidNotationMessage = invalidNotationMessage;
        this.allowNullInput = allowNullInput;
        this.delegate = delegate;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        this.delegate.describe(candidateFormats);
    }

    @Override
    public T parseNotation(N notation) {
        String failure;
        if (notation == null && !this.allowNullInput) {
            failure = String.format("Cannot convert a null value to %s.", this.targetTypeDisplayName);
        } else {
            try {
                return this.delegate.parseNotation(notation);
            }
            catch (UnsupportedNotationException e) {
                failure = String.format("Cannot convert the provided notation to %s: %s.", this.targetTypeDisplayName, e.getNotation());
            }
        }
        ArrayList<String> formats = new ArrayList<String>();
        this.describe(formats);
        throw new UnsupportedNotationException(notation, failure, this.invalidNotationMessage, formats);
    }
}

