/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds.realm;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.Entry;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.classworlds.strategy.Strategy;
import org.codehaus.plexus.classworlds.strategy.StrategyFactory;

public class ClassRealm
extends URLClassLoader {
    private ClassWorld world;
    private String id;
    private TreeSet imports;
    private Strategy strategy;
    private ClassRealm parent;

    public ClassRealm(ClassWorld world, String id) {
        this(world, id, null);
    }

    public ClassRealm(ClassWorld world, String id, ClassLoader foreignClassLoader) {
        super(new URL[0], foreignClassLoader);
        this.world = world;
        this.id = id;
        this.imports = new TreeSet();
        this.strategy = StrategyFactory.getStrategy(this, foreignClassLoader);
        if (foreignClassLoader != null && foreignClassLoader instanceof ClassRealm) {
            this.parent = (ClassRealm)foreignClassLoader;
        }
    }

    public String getId() {
        return this.id;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    public void importFrom(String realmId, String packageName) throws NoSuchRealmException {
        this.imports.add(new Entry(this.getWorld().getRealm(realmId), packageName));
        this.imports.add(new Entry(this.getWorld().getRealm(realmId), packageName.replace('.', '/')));
    }

    public ClassRealm locateSourceRealm(String classname) {
        Iterator iterator = this.imports.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.matches(classname)) continue;
            return entry.getRealm();
        }
        return this;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setParentRealm(ClassRealm realm) {
        this.parent = realm;
    }

    public ClassRealm getParentRealm() {
        return this.parent;
    }

    public ClassRealm createChildRealm(String id) throws DuplicateRealmException {
        ClassRealm childRealm = this.getWorld().newRealm(id, this);
        childRealm.setParentRealm(this);
        return childRealm;
    }

    public void addURL(URL url) {
        String urlStr = url.toExternalForm();
        if (urlStr.startsWith("jar:") && urlStr.endsWith("!/")) {
            urlStr = urlStr.substring(4, urlStr.length() - 2);
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        super.addURL(url);
    }

    public Class loadRealmClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    public URL getRealmResource(String name) {
        return super.getResource(name);
    }

    public InputStream getRealmResourceAsStream(String name) {
        return super.getResourceAsStream(name);
    }

    public Enumeration findRealmResources(String name) throws IOException {
        return super.findResources(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.strategy.loadClass(name);
    }

    public URL getResource(String name) {
        return this.strategy.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.strategy.getResourceAsStream(name);
    }

    public Enumeration findResources(String name) throws IOException {
        return this.strategy.findResources(name);
    }

    public void display() {
        System.out.println("-----------------------------------------------------");
        for (ClassRealm cr = this; cr != null; cr = cr.getParentRealm()) {
            System.out.println("this realm =    " + cr.getId());
            System.out.println("this strategy = " + this.getStrategy().getClass().getName());
            this.showUrls(cr);
            System.out.println("\n");
        }
        System.out.println("-----------------------------------------------------");
    }

    private void showUrls(ClassRealm classRealm) {
        URL[] urls = classRealm.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("urls[" + i + "] = " + urls[i]);
        }
        System.out.println("Number of imports: " + this.imports.size());
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            System.out.println("import: " + i.next());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassRealm)) {
            return false;
        }
        return this.getId().equals(((ClassRealm)o).getId());
    }

    public String toString() {
        return "ClassRealm[" + this.getId() + ", parent: " + this.getParentRealm() + "]";
    }
}

