/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.core.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;
import reactor.fn.Consumer;
import reactor.rx.Promise;
import reactor.rx.Promises;

public abstract class AdaptingListenableFutureProcessor<T, V>
implements ListenableFuture<V>,
Processor<T, V> {
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final Promise<V> promise = Promises.prepare();

    public void subscribe(Subscriber<? super V> s) {
        this.promise.subscribe(s);
    }

    public void onSubscribe(Subscription s) {
        this.promise.onSubscribe(s);
    }

    public void onNext(T t) {
        this.promise.onNext(this.adapt(t));
    }

    public void onError(Throwable t) {
        this.promise.onError(t);
    }

    public void onComplete() {
        this.promise.onComplete();
    }

    public void addCallback(ListenableFutureCallback<? super V> callback) {
        this.addCallback((SuccessCallback<? super V>)callback, (FailureCallback)callback);
    }

    public void addCallback(final SuccessCallback<? super V> successCallback, final FailureCallback failureCallback) {
        this.promise.onSuccess(new Consumer<V>(){

            public void accept(V val) {
                if (null != successCallback) {
                    successCallback.onSuccess(val);
                }
            }
        }).onError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                if (null != failureCallback) {
                    failureCallback.onFailure(throwable);
                }
            }
        });
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.promise.isPending() && this.cancelled.compareAndSet(false, true)) {
            this.promise.onComplete();
            return true;
        }
        return this.cancelled.get();
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public boolean isDone() {
        return this.promise.isComplete();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.promise.await();
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.promise.await(timeout, unit);
    }

    protected abstract V adapt(T var1);
}

