/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.factory;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;
import reactor.Environment;
import reactor.bus.EventBus;
import reactor.bus.spec.EventBusSpec;
import reactor.spring.factory.EventRouting;

public class EventBusFactoryBean
implements FactoryBean<EventBus> {
    private volatile EventBus eventBus;

    public EventBusFactoryBean(Environment env) {
        this(env, null, null);
    }

    public EventBusFactoryBean(Environment env, String dispatcher) {
        this(env, dispatcher, null);
    }

    public EventBusFactoryBean(Environment env, String dispatcher, EventRouting eventRouting) {
        Assert.notNull((Object)env, (String)"Environment cannot be null.");
        EventBusSpec spec = (EventBusSpec)EventBus.config().env(env);
        if (null != dispatcher) {
            if ("sync".equals(dispatcher)) {
                spec.synchronousDispatcher();
            } else {
                spec.dispatcher(dispatcher);
            }
        }
        if (null != eventRouting) {
            switch (eventRouting) {
                case BROADCAST_EVENT_ROUTING: {
                    spec.broadcastEventRouting();
                    break;
                }
                case RANDOM_EVENT_ROUTING: {
                    spec.randomEventRouting();
                    break;
                }
                case ROUND_ROBIN_EVENT_ROUTING: {
                    spec.roundRobinEventRouting();
                }
            }
        }
        this.eventBus = (EventBus)spec.get();
    }

    public EventBus getObject() throws Exception {
        return this.eventBus;
    }

    public Class<?> getObjectType() {
        return EventBus.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

