/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import java.util.Set;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class WebMergedContextConfiguration
extends MergedContextConfiguration {
    private static final long serialVersionUID = 7323361588604247458L;
    private final String resourceBasePath;

    @Deprecated
    public WebMergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> contextInitializerClasses, String[] activeProfiles, String resourceBasePath, ContextLoader contextLoader) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, null, null, resourceBasePath, contextLoader, null, null);
    }

    @Deprecated
    public WebMergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> contextInitializerClasses, String[] activeProfiles, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, MergedContextConfiguration parent) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, null, null, resourceBasePath, contextLoader, cacheAwareContextLoaderDelegate, parent);
    }

    public WebMergedContextConfiguration(MergedContextConfiguration mergedConfig, String resourceBasePath) {
        super(mergedConfig);
        this.resourceBasePath = !StringUtils.hasText((String)resourceBasePath) ? "" : resourceBasePath;
    }

    public WebMergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> contextInitializerClasses, String[] activeProfiles, String[] propertySourceLocations, String[] propertySourceProperties, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, MergedContextConfiguration parent) {
        super(testClass, locations, classes, contextInitializerClasses, activeProfiles, propertySourceLocations, propertySourceProperties, contextLoader, cacheAwareContextLoaderDelegate, parent);
        this.resourceBasePath = !StringUtils.hasText((String)resourceBasePath) ? "" : resourceBasePath;
    }

    public String getResourceBasePath() {
        return this.resourceBasePath;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebMergedContextConfiguration)) {
            return false;
        }
        WebMergedContextConfiguration otherConfig = (WebMergedContextConfiguration)other;
        return super.equals(otherConfig) && this.getResourceBasePath().equals(otherConfig.getResourceBasePath());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.resourceBasePath.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.getTestClass()).append("locations", (Object)ObjectUtils.nullSafeToString((Object[])this.getLocations())).append("classes", (Object)ObjectUtils.nullSafeToString((Object[])this.getClasses())).append("contextInitializerClasses", (Object)ObjectUtils.nullSafeToString(this.getContextInitializerClasses())).append("activeProfiles", (Object)ObjectUtils.nullSafeToString((Object[])this.getActiveProfiles())).append("propertySourceLocations", (Object)ObjectUtils.nullSafeToString((Object[])this.getPropertySourceLocations())).append("propertySourceProperties", (Object)ObjectUtils.nullSafeToString((Object[])this.getPropertySourceProperties())).append("resourceBasePath", (Object)this.getResourceBasePath()).append("contextLoader", (Object)WebMergedContextConfiguration.nullSafeToString(this.getContextLoader())).append("parent", (Object)this.getParent()).toString();
    }
}

