/*
 * Decompiled with CFR 0.152.
 */
package org.grails.charsequences;

import java.io.IOException;
import java.io.Writer;
import org.grails.charsequences.CharArrayAccessible;
import org.grails.charsequences.CharArrayCharSequence;
import org.grails.charsequences.SingleCharCharSequence;
import org.grails.charsequences.SubCharSequence;

public class CharSequences {
    public static CharSequence createCharSequence(char[] chars) {
        return new CharArrayCharSequence(chars, 0, chars.length);
    }

    public static CharSequence createCharSequence(char[] chars, int start, int count) {
        return new CharArrayCharSequence(chars, start, count);
    }

    public static CharSequence createCharSequence(CharSequence str, int start, int count) {
        if (CharSequences.canUseOriginalForSubSequence(str, start, count)) {
            return str;
        }
        return new SubCharSequence(str, start, count);
    }

    public static boolean canUseOriginalForSubSequence(CharSequence str, int start, int count) {
        if (start != 0) {
            return false;
        }
        Class<?> csqClass = str.getClass();
        return (csqClass == String.class || csqClass == StringBuilder.class || csqClass == StringBuffer.class) && count == str.length();
    }

    public static CharSequence createSingleCharSequence(int c) {
        return new SingleCharCharSequence(c);
    }

    public static CharSequence createSingleCharSequence(char ch) {
        return new SingleCharCharSequence(ch);
    }

    public static void writeCharSequence(Writer target, CharSequence csq, int start, int end) throws IOException {
        Class<?> csqClass = csq.getClass();
        if (csqClass == String.class) {
            target.write((String)csq, start, end - start);
        } else if (csqClass == StringBuffer.class) {
            char[] buf = new char[end - start];
            ((StringBuffer)csq).getChars(start, end, buf, 0);
            target.write(buf);
        } else if (csqClass == StringBuilder.class) {
            char[] buf = new char[end - start];
            ((StringBuilder)csq).getChars(start, end, buf, 0);
            target.write(buf);
        } else if (csq instanceof CharArrayAccessible) {
            char[] buf = new char[end - start];
            ((CharArrayAccessible)((Object)csq)).getChars(start, end, buf, 0);
            target.write(buf);
        } else {
            String str = csq.subSequence(start, end).toString();
            target.write(str, 0, str.length());
        }
    }

    public static void writeCharSequence(Writer target, CharSequence csq) throws IOException {
        CharSequences.writeCharSequence(target, csq, 0, csq.length());
    }

    public static void getChars(CharSequence csq, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        Class<?> csqClass = csq.getClass();
        if (csqClass == String.class) {
            ((String)csq).getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (csqClass == StringBuffer.class) {
            ((StringBuffer)csq).getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (csqClass == StringBuilder.class) {
            ((StringBuilder)csq).getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (csq instanceof CharArrayAccessible) {
            ((CharArrayAccessible)((Object)csq)).getChars(srcBegin, srcEnd, dst, dstBegin);
        } else {
            String str = csq.subSequence(srcBegin, srcEnd).toString();
            str.getChars(0, str.length(), dst, dstBegin);
        }
    }
}

