/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context;

import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class ContextIdApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final String NAME_PATTERN = "${vcap.application.name:${spring.application.name:${spring.config.name:application}}}";
    private static final String INDEX_PATTERN = "${vcap.application.instance_index:${spring.application.index:${server.port:${PORT:null}}}}";
    private final String name;
    private int order = 0x7FFFFFF5;

    public ContextIdApplicationContextInitializer() {
        this(NAME_PATTERN);
    }

    public ContextIdApplicationContextInitializer(String name) {
        this.name = name;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.setId(this.getApplicationId(applicationContext.getEnvironment()));
    }

    private String getApplicationId(ConfigurableEnvironment environment) {
        String name = environment.resolvePlaceholders(this.name);
        String index = environment.resolvePlaceholders(INDEX_PATTERN);
        String profiles = StringUtils.arrayToCommaDelimitedString((Object[])environment.getActiveProfiles());
        if (StringUtils.hasText((String)profiles)) {
            name = name + ":" + profiles;
        }
        if (!"null".equals(index)) {
            name = name + ":" + index;
        }
        return name;
    }
}

