/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.AbstractConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;

public abstract class AbstractEmbeddedServletContainerFactory
extends AbstractConfigurableEmbeddedServletContainer
implements EmbeddedServletContainerFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String[] COMMON_DOC_ROOTS = new String[]{"src/main/webapp", "public", "static"};

    public AbstractEmbeddedServletContainerFactory() {
    }

    public AbstractEmbeddedServletContainerFactory(int port) {
        super(port);
    }

    public AbstractEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    protected final File getValidDocumentRoot() {
        File file = this.getDocumentRoot();
        file = file != null ? file : this.getWarFileDocumentRoot();
        file = file != null ? file : this.getExplodedWarFileDocumentRoot();
        File file2 = file = file != null ? file : this.getCommonDocumentRoot();
        if (file == null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("None of the document roots " + Arrays.asList(COMMON_DOC_ROOTS) + " point to a directory and will be ignored."));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Document root: " + file));
        }
        return file;
    }

    private File getExplodedWarFileDocumentRoot() {
        File file = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Code archive: " + file));
        }
        if (file != null && file.exists() && file.getAbsolutePath().contains("/WEB-INF/")) {
            String path = file.getAbsolutePath();
            path = path.substring(0, path.indexOf("/WEB-INF/"));
            return new File(path);
        }
        return null;
    }

    private File getWarFileDocumentRoot() {
        return this.getArchiveFileDocumentRoot(".war");
    }

    private File getArchiveFileDocumentRoot(String extension) {
        File file = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Code archive: " + file));
        }
        if (file != null && file.exists() && !file.isDirectory() && file.getName().toLowerCase().endsWith(extension)) {
            return file.getAbsoluteFile();
        }
        return null;
    }

    private File getCommonDocumentRoot() {
        for (String commonDocRoot : COMMON_DOC_ROOTS) {
            File root = new File(commonDocRoot);
            if (root == null || !root.exists() || !root.isDirectory()) continue;
            return root.getAbsoluteFile();
        }
        return null;
    }

    private File getCodeSourceArchive() {
        try {
            URL location;
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            URL uRL = location = codeSource == null ? null : codeSource.getLocation();
            if (location == null) {
                return null;
            }
            String path = location.getPath();
            URLConnection connection = location.openConnection();
            if (connection instanceof JarURLConnection) {
                path = ((JarURLConnection)connection).getJarFile().getName();
            }
            if (path.indexOf("!/") != -1) {
                path = path.substring(0, path.indexOf("!/"));
            }
            return new File(path);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

