/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.plugins.GrailsPluginInfo;
import grails.util.GrailsNameUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.grails.io.support.Resource;

class PluginAstReader {
    private BasicGrailsPluginInfo pluginInfo = new BasicGrailsPluginInfo();

    GrailsPluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    public GrailsPluginInfo readPluginInfo(ClassNode classNode) throws CompilationFailedException {
        String className = classNode.getNameWithoutPackage();
        if (className.endsWith("GrailsPlugin")) {
            this.visitContents(className, classNode);
        }
        return this.pluginInfo;
    }

    protected void visitContents(String className, final ClassNode classNode) {
        ClassCodeVisitorSupport visitor = new ClassCodeVisitorSupport(){

            public void visitProperty(PropertyNode node) {
                String name = node.getName();
                Expression expr = node.getField().getInitialExpression();
                if (expr != null) {
                    ArrayList<String> value = null;
                    if (expr instanceof ListExpression) {
                        ArrayList<String> list = new ArrayList<String>();
                        for (Expression i : ((ListExpression)expr).getExpressions()) {
                            list.add(i.getText());
                        }
                        value = list;
                    } else if (expr instanceof MapExpression) {
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        value = map;
                        for (MapEntryExpression mee : ((MapExpression)expr).getMapEntryExpressions()) {
                            map.put(mee.getKeyExpression().getText(), mee.getValueExpression().getText());
                        }
                    } else if (expr instanceof ConstantExpression) {
                        value = expr.getText();
                    }
                    if (value != null) {
                        PluginAstReader.this.pluginInfo.setProperty(name, value);
                        super.visitProperty(node);
                    }
                }
            }

            protected SourceUnit getSourceUnit() {
                return classNode.getModule().getContext();
            }
        };
        classNode.visitContents((GroovyClassVisitor)visitor);
        this.pluginInfo.setName(GrailsNameUtils.getPluginName((String)(className + ".groovy")));
    }

    public class BasicGrailsPluginInfo
    implements GrailsPluginInfo {
        private String name;
        private String version;
        private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setProperty(String property, Object newValue) {
            this.attributes.put(property, newValue);
        }

        public Object getProperty(String property) {
            return this.attributes.get(property);
        }

        public String getFullName() {
            return this.name + '-' + this.version;
        }

        public Resource getDescriptor() {
            return null;
        }

        public Resource getPluginDir() {
            return null;
        }

        public Map getProperties() {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.putAll(this.attributes);
            props.put("name", this.name);
            props.put("version", this.version);
            return props;
        }
    }
}

