/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.core.GrailsApplication;
import grails.io.IOUtils;
import grails.plugins.exceptions.PluginException;
import groovy.util.slurpersupport.GPathResult;
import groovy.util.slurpersupport.Node;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.grails.core.io.StaticResourceLoader;
import org.grails.plugins.BinaryGrailsPluginDescriptor;
import org.grails.plugins.DefaultGrailsPlugin;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class BinaryGrailsPlugin
extends DefaultGrailsPlugin {
    public static final String VIEWS_PROPERTIES = "views.properties";
    public static final String RELATIVE_VIEWS_PROPERTIES = "../gsp/views.properties";
    public static final char UNDERSCORE = '_';
    public static final String PROPERTIES_EXTENSION = ".properties";
    private BinaryGrailsPluginDescriptor descriptor;
    private Class[] providedArtefacts = new Class[0];
    private Map<String, Class> precompiledViewMap = new HashMap<String, Class>();

    public BinaryGrailsPlugin(Class<?> pluginClass, BinaryGrailsPluginDescriptor descriptor, GrailsApplication application) {
        super(pluginClass, application);
        this.descriptor = descriptor;
        if (descriptor != null) {
            this.initializeProvidedArtefacts(descriptor.getParsedXml());
            this.initializeViewMap(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeViewMap(BinaryGrailsPluginDescriptor descriptor) {
        Resource descriptorResource = descriptor.getResource();
        Resource viewsPropertiesResource = null;
        try {
            viewsPropertiesResource = descriptorResource.createRelative(VIEWS_PROPERTIES);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (viewsPropertiesResource == null || !viewsPropertiesResource.exists()) {
            try {
                viewsPropertiesResource = descriptorResource.createRelative(RELATIVE_VIEWS_PROPERTIES);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (viewsPropertiesResource == null || !viewsPropertiesResource.exists()) {
            return;
        }
        Properties viewsProperties = new Properties();
        InputStream input = null;
        try {
            input = viewsPropertiesResource.getInputStream();
            viewsProperties.load(input);
            for (Object view : viewsProperties.keySet()) {
                String viewName = view.toString();
                String viewClassName = viewsProperties.getProperty(viewName);
                try {
                    Class<?> viewClass = this.application.getClassLoader().loadClass(viewClassName);
                    this.precompiledViewMap.put(viewName, viewClass);
                }
                catch (Throwable e) {
                    throw new PluginException("Failed to initialize view [" + viewName + "] from plugin [" + this.getName() + "] : " + e.getMessage(), e);
                    return;
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error loading views for binary plugin [" + this + "]: " + e.getMessage()), (Throwable)e);
            return;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected void initializeProvidedArtefacts(GPathResult descriptor) {
        GPathResult allResources;
        GPathResult resources;
        ArrayList artefacts = new ArrayList();
        if (descriptor != null && !(resources = (GPathResult)descriptor.getProperty("resources")).isEmpty() && !(allResources = (GPathResult)resources.getProperty("resource")).isEmpty()) {
            ClassLoader classLoader = this.application.getClassLoader();
            Iterator i = allResources.nodeIterator();
            while (i.hasNext()) {
                String className = ((Node)i.next()).text();
                try {
                    artefacts.add(classLoader.loadClass(className));
                }
                catch (Throwable e) {
                    throw new PluginException("Failed to initialize class [" + className + "] from plugin [" + this.getName() + "] : " + e.getMessage(), e);
                }
            }
        }
        artefacts.addAll(Arrays.asList(super.getProvidedArtefacts()));
        this.providedArtefacts = artefacts.toArray(new Class[artefacts.size()]);
    }

    @Override
    public Class<?>[] getProvidedArtefacts() {
        return this.providedArtefacts;
    }

    public BinaryGrailsPluginDescriptor getBinaryDescriptor() {
        return this.descriptor;
    }

    public Resource getResource(String path) {
        Resource descriptorResource = this.descriptor.getResource();
        try {
            Resource resource = descriptorResource.createRelative("static" + path);
            if (resource.exists()) {
                return resource;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public Properties getProperties(Locale locale) {
        Resource url = this.findPluginJar();
        Properties properties = null;
        if (url != null) {
            StaticResourceLoader resourceLoader = new StaticResourceLoader();
            resourceLoader.setBaseResource(url);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)resourceLoader);
            try {
                Resource[] resources = resolver.getResources("*.properties");
                resources = this.filterResources(resources, locale);
                properties = new Properties();
                Arrays.sort(resources, new Comparator<Resource>(){

                    @Override
                    public int compare(Resource o1, Resource o2) {
                        int secondUnderscoreCount;
                        String f1 = o1.getFilename();
                        String f2 = o2.getFilename();
                        int firstUnderscoreCount = StringUtils.countOccurrencesOf((String)f1, (String)"_");
                        if (firstUnderscoreCount == (secondUnderscoreCount = StringUtils.countOccurrencesOf((String)f2, (String)"_"))) {
                            return 0;
                        }
                        return firstUnderscoreCount > secondUnderscoreCount ? 1 : -1;
                    }
                });
                this.loadFromResources(properties, resources);
            }
            catch (IOException e) {
                return null;
            }
        }
        return properties;
    }

    protected Resource findPluginJar() {
        URL url = IOUtils.findJarResource((Class)this.pluginClass);
        if (url != null) {
            return new UrlResource(url);
        }
        return null;
    }

    private Resource[] filterResources(Resource[] resources, Locale locale) {
        ArrayList<Resource> finalResources = new ArrayList<Resource>(resources.length);
        for (Resource resource : resources) {
            String fn = resource.getFilename();
            if (fn.indexOf(95) > -1) {
                if (fn.endsWith('_' + locale.toString() + PROPERTIES_EXTENSION)) {
                    finalResources.add(resource);
                    continue;
                }
                if (fn.endsWith('_' + locale.getLanguage() + '_' + locale.getCountry() + PROPERTIES_EXTENSION)) {
                    finalResources.add(resource);
                    continue;
                }
                if (!fn.endsWith('_' + locale.getLanguage() + PROPERTIES_EXTENSION)) continue;
                finalResources.add(resource);
                continue;
            }
            finalResources.add(resource);
        }
        return finalResources.toArray(new Resource[finalResources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromResources(Properties properties, Resource[] resources) throws IOException {
        for (Resource messageResource : resources) {
            InputStream inputStream = messageResource.getInputStream();
            try {
                properties.load(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Class resolveView(String viewName) {
        String extraPath = "/plugins/" + this.getName() + '-' + this.getVersion() + '/';
        viewName = viewName.replace(extraPath, "/");
        return this.precompiledViewMap.get(viewName);
    }
}

