/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.processor;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.core.support.NonBlocking;
import reactor.fn.Consumer;
import reactor.fn.Resource;

public abstract class ReactorProcessor<IN, OUT>
implements Processor<IN, OUT>,
Consumer<IN>,
NonBlocking,
Resource {
    protected static final int SMALL_BUFFER_SIZE = 32;
    protected final boolean autoCancel;
    private volatile int subscriberCount = 0;
    protected static final AtomicIntegerFieldUpdater<ReactorProcessor> SUBSCRIBER_COUNT = AtomicIntegerFieldUpdater.newUpdater(ReactorProcessor.class, "subscriberCount");
    protected Subscription upstreamSubscription;

    public ReactorProcessor(boolean autoCancel) {
        this.autoCancel = autoCancel;
    }

    @Override
    public final void accept(IN e) {
        this.onNext(e);
    }

    public void onSubscribe(Subscription s) {
        if (this.upstreamSubscription != null) {
            s.cancel();
            return;
        }
        this.upstreamSubscription = s;
    }

    protected boolean incrementSubscribers() {
        return SUBSCRIBER_COUNT.getAndIncrement(this) == 0;
    }

    protected int decrementSubscribers() {
        Subscription subscription = this.upstreamSubscription;
        int subs = SUBSCRIBER_COUNT.decrementAndGet(this);
        if (subs == 0) {
            if (subscription != null && this.autoCancel) {
                this.upstreamSubscription = null;
                subscription.cancel();
            }
            return subs;
        }
        return subs;
    }

    public abstract long getAvailableCapacity();

    @Override
    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
        return false;
    }
}

