/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.function;

import com.gs.collections.api.block.function.Function2;
import java.util.Collection;
import java.util.Map;

public final class MaxSizeFunction {
    public static final Function2<Integer, String, Integer> STRING = new MaxSizeStringFunction();
    public static final Function2<Integer, Collection<?>, Integer> COLLECTION = new MaxSizeCollectionFunction();
    public static final Function2<Integer, Map<?, ?>, Integer> MAP = new MaxSizeMapFunction();

    private MaxSizeFunction() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaxSizeMapFunction
    implements Function2<Integer, Map<?, ?>, Integer> {
        private static final long serialVersionUID = 1L;

        private MaxSizeMapFunction() {
        }

        public Integer value(Integer previousMax, Map<?, ?> map) {
            return Math.max(previousMax, map.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaxSizeCollectionFunction
    implements Function2<Integer, Collection<?>, Integer> {
        private static final long serialVersionUID = 1L;

        private MaxSizeCollectionFunction() {
        }

        public Integer value(Integer previousMax, Collection<?> collection) {
            return Math.max(previousMax, collection.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaxSizeStringFunction
    implements Function2<Integer, String, Integer> {
        private static final long serialVersionUID = 1L;

        private MaxSizeStringFunction() {
        }

        public Integer value(Integer previousMax, String s) {
            return Math.max(previousMax, s.length());
        }
    }
}

