/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.fixed;

import com.gs.collections.api.factory.map.FixedSizeMapFactory;
import com.gs.collections.api.map.FixedSizeMap;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.map.fixed.DoubletonMap;
import com.gs.collections.impl.map.fixed.EmptyMap;
import com.gs.collections.impl.map.fixed.SingletonMap;
import com.gs.collections.impl.map.fixed.TripletonMap;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class FixedSizeMapFactoryImpl
implements FixedSizeMapFactory {
    private static final FixedSizeMap<?, ?> EMPTY_MAP = new EmptyMap();

    public <K, V> FixedSizeMap<K, V> of() {
        return this.with();
    }

    public <K, V> FixedSizeMap<K, V> with() {
        return EMPTY_MAP;
    }

    public <K, V> FixedSizeMap<K, V> of(K key, V value) {
        return this.with(key, value);
    }

    public <K, V> FixedSizeMap<K, V> with(K key, V value) {
        return new SingletonMap<K, V>(key, value);
    }

    public <K, V> FixedSizeMap<K, V> of(K key1, V value1, K key2, V value2) {
        return this.with(key1, value1, key2, value2);
    }

    public <K, V> FixedSizeMap<K, V> with(K key1, V value1, K key2, V value2) {
        if (Comparators.nullSafeEquals(key1, key2)) {
            return this.of(key1, value2);
        }
        return new DoubletonMap<K, V>(key1, value1, key2, value2);
    }

    public <K, V> FixedSizeMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        return this.with(key1, value1, key2, value2, key3, value3);
    }

    public <K, V> FixedSizeMap<K, V> with(K key1, V value1, K key2, V value2, K key3, V value3) {
        if (Comparators.nullSafeEquals(key1, key2) && Comparators.nullSafeEquals(key2, key3)) {
            return this.of(key1, value3);
        }
        if (Comparators.nullSafeEquals(key1, key2)) {
            return this.of(key1, value2, key3, value3);
        }
        if (Comparators.nullSafeEquals(key1, key3)) {
            return this.of(key2, value2, key1, value3);
        }
        if (Comparators.nullSafeEquals(key2, key3)) {
            return this.of(key1, value1, key2, value3);
        }
        return new TripletonMap<K, V>(key1, value1, key2, value2, key3, value3);
    }
}

