/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.FloatShortMap;
import com.gs.collections.api.map.primitive.ImmutableFloatShortMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.FloatShortPair;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.FloatShortMaps;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.FloatShortHashMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatShortSingletonMap
implements ImmutableFloatShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_VALUE = 0;
    private final float key1;
    private final short value1;

    ImmutableFloatShortSingletonMap(float key1, short value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public short get(float key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(float key, short ifAbsent) {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    public short getOrThrow(float key) {
        if (Float.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        return Float.compare(this.key1, key) == 0;
    }

    public boolean containsValue(short value) {
        return this.value1 == value;
    }

    public void forEachValue(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(FloatProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(FloatShortProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyFloatIterable keysView() {
        return FloatLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<FloatShortPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableFloatShortMap select(FloatShortPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? FloatShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new FloatShortHashMap().toImmutable();
    }

    public ImmutableFloatShortMap reject(FloatShortPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new FloatShortHashMap().toImmutable() : FloatShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableFloatShortMap toImmutable() {
        return this;
    }

    public ShortIterator shortIterator() {
        return FloatShortHashMap.newWithKeysValues(this.key1, this.value1).shortIterator();
    }

    public void forEach(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public short min() {
        return this.value1;
    }

    public short max() {
        return this.value1;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.value1;
    }

    public short minIfEmpty(short defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public short[] toSortedArray() {
        return new short[]{this.value1};
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableShortCollection select(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? ShortArrayList.newListWith(this.value1).toImmutable() : new ShortArrayList().toImmutable();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? new ShortArrayList().toImmutable() : ShortArrayList.newListWith(this.value1).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public short[] toArray() {
        return new short[]{this.value1};
    }

    public boolean contains(short value) {
        return this.value1 == value;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.value1);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.value1);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.value1);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public ImmutableFloatShortMap newWithKeyValue(float key, short value) {
        return FloatShortMaps.immutable.withAll((FloatShortMap)FloatShortHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableFloatShortMap newWithoutKey(float key) {
        return Float.compare(this.key1, key) == 0 ? FloatShortMaps.immutable.with() : this;
    }

    public ImmutableFloatShortMap newWithoutAllKeys(FloatIterable keys) {
        return keys.contains(this.key1) ? FloatShortMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(FloatHashSet.newSetWith(this.key1));
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of((MutableShortCollection)ShortArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatShortMap)) {
            return false;
        }
        FloatShortMap map = (FloatShortMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.key1) ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

