/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.LongIntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableLongIntMap;
import com.gs.collections.api.map.primitive.LongIntMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.LongIntPair;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.immutable.primitive.ImmutableLongIntSingletonMap;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyLongIterate;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongIntEmptyMap
implements ImmutableLongIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    static final ImmutableLongIntMap INSTANCE = new ImmutableLongIntEmptyMap();

    ImmutableLongIntEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public int get(long key) {
        return 0;
    }

    public int getIfAbsent(long key, int ifAbsent) {
        return ifAbsent;
    }

    public int getOrThrow(long key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key) {
        return false;
    }

    public boolean containsValue(int value) {
        return false;
    }

    public void forEachValue(IntProcedure procedure) {
    }

    public void forEachKey(LongProcedure procedure) {
    }

    public void forEachKeyValue(LongIntProcedure procedure) {
    }

    public LazyLongIterable keysView() {
        return LazyLongIterate.empty();
    }

    public RichIterable<LongIntPair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableLongIntMap select(LongIntPredicate predicate) {
        return this;
    }

    public ImmutableLongIntMap reject(LongIntPredicate predicate) {
        return this;
    }

    public ImmutableLongIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    public void forEach(IntProcedure procedure) {
    }

    public int count(IntPredicate predicate) {
        return 0;
    }

    public long sum() {
        return 0L;
    }

    public int min() {
        throw new NoSuchElementException();
    }

    public int max() {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public int[] toSortedArray() {
        return new int[0];
    }

    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    public ImmutableIntCollection select(IntPredicate predicate) {
        return IntLists.immutable.with();
    }

    public ImmutableIntCollection reject(IntPredicate predicate) {
        return IntLists.immutable.with();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public int[] toArray() {
        return new int[0];
    }

    public boolean contains(int value) {
        return false;
    }

    public boolean containsAll(int ... source) {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    public MutableIntList toList() {
        return new IntArrayList();
    }

    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableLongIntMap newWithKeyValue(long key, int value) {
        return new ImmutableLongIntSingletonMap(key, value);
    }

    public ImmutableLongIntMap newWithoutKey(long key) {
        return this;
    }

    public ImmutableLongIntMap newWithoutAllKeys(LongIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(new LongHashSet());
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of((MutableIntCollection)new IntArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongIntMap)) {
            return false;
        }
        LongIntMap map = (LongIntMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InternalIntIterator
    implements IntIterator {
        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public int next() {
            throw new NoSuchElementException();
        }
    }
}

