/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectBooleanPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectBooleanProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ImmutableObjectBooleanMap;
import com.gs.collections.api.map.primitive.ObjectBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.tuple.primitive.ObjectBooleanPair;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.ObjectBooleanMaps;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableObjectBooleanMap;
import com.gs.collections.impl.map.immutable.primitive.ImmutableObjectBooleanEmptyMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectBooleanHashMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableObjectBooleanSingletonMap<K>
extends AbstractImmutableObjectBooleanMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean EMPTY_VALUE = false;
    private final K key1;
    private final boolean value1;

    ImmutableObjectBooleanSingletonMap(K key1, boolean value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public BooleanIterator booleanIterator() {
        return ObjectBooleanHashMap.newWithKeysValues(this.key1, this.value1).booleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? BooleanLists.immutable.with(this.value1) : BooleanLists.immutable.with();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? BooleanLists.immutable.with() : BooleanLists.immutable.with(this.value1);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public boolean[] toArray() {
        return new boolean[]{this.value1};
    }

    public boolean contains(boolean value) {
        return this.value1 == value;
    }

    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newListWith(this.value1);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSetWith(this.value1);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBagWith(this.value1);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public ImmutableObjectBooleanMap<K> newWithKeyValue(K key, boolean value) {
        return ObjectBooleanMaps.immutable.withAll(ObjectBooleanHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectBooleanMap<K> newWithoutKey(K key) {
        return ImmutableObjectBooleanSingletonMap.nullSafeEquals(this.key1, key) ? ImmutableObjectBooleanEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public ImmutableObjectBooleanMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectBooleanHashMap<K> map = new ObjectBooleanHashMap<K>(this);
        for (K key : keys) {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public boolean get(Object key) {
        return this.getIfAbsent(key, false);
    }

    public boolean getOrThrow(Object key) {
        if (ImmutableObjectBooleanSingletonMap.nullSafeEquals(this.key1, key)) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsent(Object key, boolean ifAbsent) {
        return ImmutableObjectBooleanSingletonMap.nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key) {
        return ImmutableObjectBooleanSingletonMap.nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(boolean value) {
        return this.value1 == value;
    }

    public void forEachValue(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectBooleanProcedure<? super K> objectBooleanProcedure) {
        objectBooleanProcedure.value(this.key1, this.value1);
    }

    public ImmutableObjectBooleanMap<K> select(ObjectBooleanPredicate<? super K> objectBooleanPredicate) {
        return objectBooleanPredicate.accept(this.key1, this.value1) ? ObjectBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableObjectBooleanEmptyMap.INSTANCE;
    }

    public ImmutableObjectBooleanMap<K> reject(ObjectBooleanPredicate<? super K> objectBooleanPredicate) {
        return objectBooleanPredicate.accept(this.key1, this.value1) ? ImmutableObjectBooleanEmptyMap.INSTANCE : ObjectBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectBooleanMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public Set<K> keySet() {
        return Sets.immutable.of(this.key1).castToSet();
    }

    public MutableBooleanCollection values() {
        return UnmodifiableBooleanCollection.of((MutableBooleanCollection)BooleanArrayList.newListWith(this.value1));
    }

    public LazyIterable<K> keysView() {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ObjectBooleanPair<K>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectBooleanMap)) {
            return false;
        }
        ObjectBooleanMap map = (ObjectBooleanMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ (this.value1 ? 1231 : 1237);
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectBooleanMap.ImmutableObjectBooleanMapSerializationProxy(this);
    }
}

