/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongToIntFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.LongIntPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableLongIntMap;
import com.gs.collections.api.map.primitive.LongIntMap;
import com.gs.collections.api.map.primitive.MutableLongIntMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.LongIntPair;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.factory.primitive.LongIntMaps;
import com.gs.collections.impl.factory.primitive.LongSets;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedLongIntMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableLongIntMap;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedLongSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongIntHashMap
implements MutableLongIntMap,
Externalizable {
    static final int EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private long[] keys;
    private int[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public LongIntHashMap() {
        this.allocateTable(16);
    }

    public LongIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public LongIntHashMap(LongIntMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static LongIntHashMap newWithKeysValues(long key1, int value1) {
        return new LongIntHashMap(1).withKeyValue(key1, value1);
    }

    public static LongIntHashMap newWithKeysValues(long key1, int value1, long key2, int value2) {
        return new LongIntHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static LongIntHashMap newWithKeysValues(long key1, int value1, long key2, int value2, long key3, int value3) {
        return new LongIntHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static LongIntHashMap newWithKeysValues(long key1, int value1, long key2, int value2, long key3, int value3, long key4, int value4) {
        return new LongIntHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongIntMap)) {
            return false;
        }
        LongIntMap other = (LongIntMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0L) || other.containsKey(1L)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0L) || this.sentinelValues.zeroValue != other.getOrThrow(0L))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1L) || this.sentinelValues.oneValue != other.getOrThrow(1L))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongIntHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(this.keys[i] ^ this.keys[i] >>> 32) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0L)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1L)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongIntHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                long key = this.keys[i];
                if (!LongIntHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    public int[] toArray() {
        int[] array = new int[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(int value) {
        return this.containsValue(value);
    }

    public boolean containsAll(int ... source) {
        for (int each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        return source.allSatisfy(new IntPredicate(){

            public boolean accept(int value) {
                return LongIntHashMap.this.contains(value);
            }
        });
    }

    public void forEach(IntProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableIntCollection select(IntPredicate predicate) {
        IntArrayList result = new IntArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableIntCollection reject(IntPredicate predicate) {
        IntArrayList result = new IntArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public int detectIfNone(IntPredicate predicate, int value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(IntPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, 0);
    }

    public void put(long key, int value) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(LongIntMap map) {
        map.forEachKeyValue(new LongIntProcedure(){

            public void value(long key, int value) {
                LongIntHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(long key) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1L;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(long key) {
        this.removeKey(key);
    }

    public int removeKeyIfAbsent(long key, int value) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            int oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            int oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1L;
            int oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public int getIfAbsentPut(long key, int value) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int getIfAbsentPut(long key, IntFunction0 function) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> int getIfAbsentPutWith(long key, IntFunction<? super P> function, P parameter) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.intValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.intValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.intValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int getIfAbsentPutWithKey(long key, LongToIntFunction function) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int addToValue(long key, int toBeAdded) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(long key, int value, int index) {
        if (this.keys[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(int value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = 0;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(int value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = 0;
        } else {
            this.sentinelValues = null;
        }
    }

    public int updateValue(long key, int initialValueIfAbsent, IntToIntFunction function) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        int value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public LongIntHashMap withKeyValue(long key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public LongIntHashMap withKeysValues(long key1, int value1, long key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public LongIntHashMap withKeysValues(long key1, int value1, long key2, int value2, long key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public LongIntHashMap withKeysValues(long key1, int value1, long key2, int value2, long key3, int value3, long key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public LongIntHashMap withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    public LongIntHashMap withoutAllKeys(LongIterable keys) {
        keys.forEach(new LongProcedure(){

            public void value(long key) {
                LongIntHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableLongIntMap asUnmodifiable() {
        return new UnmodifiableLongIntMap(this);
    }

    public MutableLongIntMap asSynchronized() {
        return new SynchronizedLongIntMap(this);
    }

    public ImmutableLongIntMap toImmutable() {
        return LongIntMaps.immutable.ofAll((LongIntMap)this);
    }

    public int get(long key) {
        return this.getIfAbsent(key, 0);
    }

    public int getIfAbsent(long key, int ifAbsent) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public int getOrThrow(long key) {
        if (LongIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (LongIntHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key) {
        if (LongIntHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (LongIntHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(int value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L);
            }
        }
        for (long key : this.keys) {
            if (!LongIntHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(LongIntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyLongIterable keysView() {
        return new KeysView();
    }

    public RichIterable<LongIntPair> keyValuesView() {
        return new KeyValuesView();
    }

    public LongIntHashMap select(LongIntPredicate predicate) {
        LongIntHashMap result = new LongIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public LongIntHashMap reject(LongIntPredicate predicate) {
        LongIntHashMap result = new LongIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        IntIterator iterator = this.intIterator();
        int max = iterator.next();
        while (iterator.hasNext()) {
            int value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        IntIterator iterator = this.intIterator();
        int min = iterator.next();
        while (iterator.hasNext()) {
            int value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public int minIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeLong(0L);
                out.writeInt(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeLong(1L);
                out.writeInt(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongIntHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeLong(this.keys[i]);
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readLong(), in.readInt());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        long[] old = this.keys;
        int[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongIntHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(long element) {
        int index = this.spread(element);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0L) {
            return index;
        }
        int removedIndex = keyAtIndex == 1L ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1L) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0L) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(long element) {
        long code = element;
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new long[sizeToAllocate];
        this.values = new int[sizeToAllocate];
    }

    private static boolean isEmptyKey(long key) {
        return key == 0L;
    }

    private static boolean isRemovedKey(long key) {
        return key == 1L;
    }

    private static boolean isNonSentinel(long key) {
        return !LongIntHashMap.isEmptyKey(key) && !LongIntHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableLongSet keySet() {
        return new KeySet();
    }

    public MutableIntCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ long[] access$802(LongIntHashMap x0, long[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1002(LongIntHashMap x0, int[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<LongIntPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super LongIntPair> procedure) {
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0L, LongIntHashMap.this.sentinelValues.zeroValue));
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1L, LongIntHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                if (!LongIntHashMap.isNonSentinel(LongIntHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(LongIntHashMap.this.keys[i], LongIntHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super LongIntPair> objectIntProcedure) {
            int index = 0;
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0L, LongIntHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1L, LongIntHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                if (!LongIntHashMap.isNonSentinel(LongIntHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(LongIntHashMap.this.keys[i], LongIntHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super LongIntPair, ? super P> procedure, P parameter) {
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0L, LongIntHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1L, LongIntHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                if (!LongIntHashMap.isNonSentinel(LongIntHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(LongIntHashMap.this.keys[i], LongIntHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<LongIntPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<LongIntPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public LongIntPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (LongIntHashMap.this.containsKey(0L)) {
                        return PrimitiveTuples.pair(0L, LongIntHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (LongIntHashMap.this.containsKey(1L)) {
                        return PrimitiveTuples.pair(1L, LongIntHashMap.this.sentinelValues.oneValue);
                    }
                }
                long[] keys = LongIntHashMap.this.keys;
                while (!LongIntHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                LongIntPair result = PrimitiveTuples.pair(keys[this.position], LongIntHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != LongIntHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableIntCollection {
        private ValuesCollection() {
        }

        public void clear() {
            LongIntHashMap.this.clear();
        }

        public MutableIntCollection select(IntPredicate predicate) {
            return LongIntHashMap.this.select(predicate);
        }

        public MutableIntCollection reject(IntPredicate predicate) {
            return LongIntHashMap.this.reject(predicate);
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            return LongIntHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
            return LongIntHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            return LongIntHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return LongIntHashMap.this.sum();
        }

        public int max() {
            return LongIntHashMap.this.max();
        }

        public int maxIfEmpty(int defaultValue) {
            return LongIntHashMap.this.maxIfEmpty(defaultValue);
        }

        public int min() {
            return LongIntHashMap.this.min();
        }

        public int minIfEmpty(int defaultValue) {
            return LongIntHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return LongIntHashMap.this.average();
        }

        public double median() {
            return LongIntHashMap.this.median();
        }

        public int[] toSortedArray() {
            return LongIntHashMap.this.toSortedArray();
        }

        public MutableIntList toSortedList() {
            return LongIntHashMap.this.toSortedList();
        }

        public MutableIntCollection with(int element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection without(int element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection asUnmodifiable() {
            return UnmodifiableIntCollection.of(this);
        }

        public MutableIntCollection asSynchronized() {
            return SynchronizedIntCollection.of(this);
        }

        public ImmutableIntCollection toImmutable() {
            return IntLists.immutable.withAll((IntIterable)this);
        }

        public boolean contains(int value) {
            return LongIntHashMap.this.containsValue(value);
        }

        public boolean containsAll(int ... source) {
            return LongIntHashMap.this.containsAll(source);
        }

        public boolean containsAll(IntIterable source) {
            return LongIntHashMap.this.containsAll(source);
        }

        public MutableIntList toList() {
            return LongIntHashMap.this.toList();
        }

        public MutableIntSet toSet() {
            return LongIntHashMap.this.toSet();
        }

        public MutableIntBag toBag() {
            return LongIntHashMap.this.toBag();
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public boolean isEmpty() {
            return LongIntHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongIntHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongIntHashMap.this.sentinelValues != null) {
                    if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(LongIntHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(LongIntHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                    long key = LongIntHashMap.this.keys[i];
                    if (!LongIntHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(LongIntHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IntIterator intIterator() {
            return LongIntHashMap.this.intIterator();
        }

        public void forEach(IntProcedure procedure) {
            LongIntHashMap.this.forEach(procedure);
        }

        public int count(IntPredicate predicate) {
            return LongIntHashMap.this.count(predicate);
        }

        public boolean anySatisfy(IntPredicate predicate) {
            return LongIntHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(IntPredicate predicate) {
            return LongIntHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            return LongIntHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(int item) {
            int oldSize = LongIntHashMap.this.size();
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey && item == LongIntHashMap.this.sentinelValues.zeroValue) {
                    LongIntHashMap.this.removeKey(0L);
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && item == LongIntHashMap.this.sentinelValues.oneValue) {
                    LongIntHashMap.this.removeKey(1L);
                }
            }
            for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                if (!LongIntHashMap.isNonSentinel(LongIntHashMap.this.keys[i]) || item != LongIntHashMap.this.values[i]) continue;
                LongIntHashMap.this.removeKey(LongIntHashMap.this.keys[i]);
            }
            return oldSize != LongIntHashMap.this.size();
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = LongIntHashMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != LongIntHashMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = LongIntHashMap.this.size();
            for (int item : source) {
                this.remove(item);
            }
            return oldSize != LongIntHashMap.this.size();
        }

        public boolean retainAll(IntIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            LongIntHashMap retained = LongIntHashMap.this.select(new LongIntPredicate((IntSet)sourceSet){
                final /* synthetic */ IntSet val$sourceSet;
                {
                    this.val$sourceSet = intSet;
                }

                public boolean accept(long key, int value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                LongIntHashMap.access$802(LongIntHashMap.this, retained.keys);
                LongIntHashMap.access$1002(LongIntHashMap.this, retained.values);
                LongIntHashMap.this.sentinelValues = retained.sentinelValues;
                LongIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(int ... source) {
            return this.retainAll((IntIterable)IntHashSet.newSetWith(source));
        }

        public int size() {
            return LongIntHashMap.this.size();
        }

        public int[] toArray() {
            return LongIntHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableLongSet {
        private KeySet() {
        }

        public LongIterator longIterator() {
            return new KeySetIterator();
        }

        public void forEach(LongProcedure procedure) {
            LongIntHashMap.this.forEachKey(procedure);
        }

        public int count(LongPredicate predicate) {
            int count = 0;
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    ++count;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    ++count;
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(LongPredicate predicate) {
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return true;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return true;
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(LongPredicate predicate) {
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    return false;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return false;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(long key) {
            int oldSize = LongIntHashMap.this.size();
            LongIntHashMap.this.removeKey(key);
            return oldSize != LongIntHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = LongIntHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                LongIntHashMap.this.removeKey(iterator.next());
            }
            return oldSize != LongIntHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = LongIntHashMap.this.size();
            for (long item : source) {
                LongIntHashMap.this.removeKey(item);
            }
            return oldSize != LongIntHashMap.this.size();
        }

        public boolean retainAll(LongIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            LongIntHashMap retained = LongIntHashMap.this.select(new LongIntPredicate((LongSet)sourceSet){
                final /* synthetic */ LongSet val$sourceSet;
                {
                    this.val$sourceSet = longSet;
                }

                public boolean accept(long key, int value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                LongIntHashMap.access$802(LongIntHashMap.this, retained.keys);
                LongIntHashMap.access$1002(LongIntHashMap.this, retained.values);
                LongIntHashMap.this.sentinelValues = retained.sentinelValues;
                LongIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(long ... source) {
            return this.retainAll((LongIterable)LongHashSet.newSetWith(source));
        }

        public void clear() {
            LongIntHashMap.this.clear();
        }

        public MutableLongSet select(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet reject(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet with(long element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet without(long element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet withAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return 0L;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return 1L;
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0L));
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1L));
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableLongSet asUnmodifiable() {
            return UnmodifiableLongSet.of(this);
        }

        public MutableLongSet asSynchronized() {
            return SynchronizedLongSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (long key : LongIntHashMap.this.keys) {
                if (!LongIntHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public long max() {
            if (LongIntHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long max = 0L;
            boolean isMaxSet = false;
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0L;
                    isMaxSet = true;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1L)) {
                    max = 1L;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                if (!LongIntHashMap.isNonSentinel(LongIntHashMap.this.keys[i]) || isMaxSet && max >= LongIntHashMap.this.keys[i]) continue;
                max = LongIntHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public long maxIfEmpty(long defaultValue) {
            if (LongIntHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public long min() {
            if (LongIntHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long min = 0L;
            boolean isMinSet = false;
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0L;
                    isMinSet = true;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1L < min)) {
                    min = 1L;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                if (!LongIntHashMap.isNonSentinel(LongIntHashMap.this.keys[i]) || isMinSet && LongIntHashMap.this.keys[i] >= min) continue;
                min = LongIntHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public long minIfEmpty(long defaultValue) {
            if (LongIntHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            long[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                long first = sortedArray[middleIndex];
                long second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public long[] toSortedArray() {
            long[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableLongList toSortedList() {
            return LongArrayList.newList((LongIterable)this).sortThis();
        }

        public long[] toArray() {
            int size = LongIntHashMap.this.size();
            final long[] result = new long[size];
            LongIntHashMap.this.forEachKey(new LongProcedure(){
                private int index;

                public void value(long each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(long value) {
            return LongIntHashMap.this.containsKey(value);
        }

        public boolean containsAll(long ... source) {
            for (long item : source) {
                if (LongIntHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(LongIterable source) {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                if (LongIntHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableLongList toList() {
            return LongArrayList.newList((LongIterable)this);
        }

        public MutableLongSet toSet() {
            return LongHashSet.newSet((LongIterable)this);
        }

        public MutableLongBag toBag() {
            return LongHashBag.newBag((LongIterable)this);
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0L);
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1L);
                }
            }
            for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                if (!LongIntHashMap.isNonSentinel(LongIntHashMap.this.keys[i])) continue;
                result = function.valueOf(result, LongIntHashMap.this.keys[i]);
            }
            return result;
        }

        public LongSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableLongSet toImmutable() {
            return LongSets.immutable.withAll((LongIterable)this);
        }

        public int size() {
            return LongIntHashMap.this.size();
        }

        public boolean isEmpty() {
            return LongIntHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongIntHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LongSet)) {
                return false;
            }
            LongSet other = (LongSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (LongIntHashMap.this.sentinelValues != null) {
                if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < LongIntHashMap.this.keys.length; ++i) {
                if (!LongIntHashMap.isNonSentinel(LongIntHashMap.this.keys[i])) continue;
                result += (int)(LongIntHashMap.this.keys[i] ^ LongIntHashMap.this.keys[i] >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongIntHashMap.this.sentinelValues != null) {
                    if (LongIntHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0L));
                        first = false;
                    }
                    if (LongIntHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1L));
                        first = false;
                    }
                }
                for (long key : LongIntHashMap.this.keys) {
                    if (!LongIntHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < LongIntHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongIntHashMap.this.containsKey(0L)) {
                    return 0L;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongIntHashMap.this.containsKey(1L)) {
                    return 1L;
                }
            }
            long[] keys = LongIntHashMap.this.keys;
            while (!LongIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            long result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyLongIterable {
        private KeysView() {
        }

        public LongIterator longIterator() {
            return new KeySetIterator();
        }

        public void forEach(LongProcedure procedure) {
            LongIntHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalIntIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return this.count < LongIntHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongIntHashMap.this.containsKey(0L)) {
                    return LongIntHashMap.this.get(0L);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongIntHashMap.this.containsKey(1L)) {
                    return LongIntHashMap.this.get(1L);
                }
            }
            long[] keys = LongIntHashMap.this.keys;
            while (!LongIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = LongIntHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private int zeroValue;
        private int oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(int value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

