/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.sorted.immutable;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.map.sorted.ImmutableSortedMap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.collection.mutable.UnmodifiableMutableCollection;
import com.gs.collections.impl.map.sorted.immutable.AbstractImmutableSortedMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.set.mutable.UnmodifiableMutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedMap;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ImmutableTreeMap<K, V>
extends AbstractImmutableSortedMap<K, V> {
    private final TreeSortedMap<K, V> delegate;

    public ImmutableTreeMap(SortedMap<K, V> sortedMap) {
        this.delegate = TreeSortedMap.newMap(sortedMap);
    }

    public static <K, V> ImmutableSortedMap<K, V> newMap(SortedMap<K, V> sortedMap) {
        return new ImmutableTreeMap<K, V>(sortedMap);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public ImmutableMap<V, K> flipUniqueValues() {
        return this.delegate.flipUniqueValues().toImmutable();
    }

    public RichIterable<K> keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<V> valuesView() {
        return this.delegate.valuesView();
    }

    public RichIterable<Pair<K, V>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.delegate.comparator();
    }

    @Override
    public K firstKey() {
        return this.delegate.firstKey();
    }

    @Override
    public K lastKey() {
        return this.delegate.lastKey();
    }

    @Override
    public Set<K> keySet() {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    @Override
    public Collection<V> values() {
        return UnmodifiableMutableCollection.of(this.delegate.values());
    }
}

