/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.impl.block.procedure.checked.MultimapKeyValuesSerializingProcedure;
import com.gs.collections.impl.multimap.AbstractMutableMultimap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableMultimapSerializationProxy<K, V, R extends RichIterable<V>>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Multimap<K, V> multimapToReadInto;
    private ImmutableMap<K, R> mapToWrite;

    protected ImmutableMultimapSerializationProxy() {
    }

    protected ImmutableMultimapSerializationProxy(ImmutableMap<K, R> immutableMap) {
        this.mapToWrite = immutableMap;
    }

    protected abstract AbstractMutableMultimap<K, V, ?> createEmptyMutableMultimap();

    protected Object readResolve() {
        return this.multimapToReadInto.toImmutable();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int keysCount = this.mapToWrite.size();
        out.writeInt(keysCount);
        this.mapToWrite.forEachKeyValue(new MultimapKeyValuesSerializingProcedure(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        AbstractMutableMultimap<K, V, ?> toReadInto = this.createEmptyMutableMultimap();
        toReadInto.readValuesFrom(in);
        this.multimapToReadInto = toReadInto;
    }
}

