/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.parallel;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.ListIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.impl.block.procedure.MultimapPutProcedure;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.factory.Iterables;
import com.gs.collections.impl.list.fixed.ArrayAdapter;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import com.gs.collections.impl.multimap.list.SynchronizedPutFastListMultimap;
import com.gs.collections.impl.parallel.BatchIterable;
import com.gs.collections.impl.parallel.BatchIterableProcedureFJTaskRunner;
import com.gs.collections.impl.parallel.CollectionsThreadFactory;
import com.gs.collections.impl.parallel.Combiner;
import com.gs.collections.impl.parallel.Combiners;
import com.gs.collections.impl.parallel.CountCombiner;
import com.gs.collections.impl.parallel.CountProcedureFactory;
import com.gs.collections.impl.parallel.FastListCollectIfProcedureCombiner;
import com.gs.collections.impl.parallel.FastListCollectIfProcedureFactory;
import com.gs.collections.impl.parallel.FastListCollectProcedureCombiner;
import com.gs.collections.impl.parallel.FastListCollectProcedureFactory;
import com.gs.collections.impl.parallel.FastListRejectProcedureCombiner;
import com.gs.collections.impl.parallel.FastListRejectProcedureFactory;
import com.gs.collections.impl.parallel.FastListSelectProcedureCombiner;
import com.gs.collections.impl.parallel.FastListSelectProcedureFactory;
import com.gs.collections.impl.parallel.FlatCollectProcedureCombiner;
import com.gs.collections.impl.parallel.FlatCollectProcedureFactory;
import com.gs.collections.impl.parallel.ObjectIntProcedureFJTaskRunner;
import com.gs.collections.impl.parallel.ObjectIntProcedureFactory;
import com.gs.collections.impl.parallel.ParallelArrayIterate;
import com.gs.collections.impl.parallel.PassThruCombiner;
import com.gs.collections.impl.parallel.PassThruObjectIntProcedureFactory;
import com.gs.collections.impl.parallel.PassThruProcedureFactory;
import com.gs.collections.impl.parallel.ProcedureFJTaskRunner;
import com.gs.collections.impl.parallel.ProcedureFactory;
import com.gs.collections.impl.utility.Iterate;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParallelIterate {
    static final int DEFAULT_MIN_FORK_SIZE = 10000;
    static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    static final int TASK_RATIO = 2;
    static final int DEFAULT_PARALLEL_TASK_COUNT = ParallelIterate.getDefaultTaskCount();
    static final ExecutorService EXECUTOR_SERVICE = ParallelIterate.newPooledExecutor(ParallelIterate.class.getSimpleName(), true);

    private ParallelIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    static boolean isExecutorShutdown() {
        return EXECUTOR_SERVICE.isShutdown();
    }

    static void shutdownExecutor() {
        EXECUTOR_SERVICE.shutdown();
    }

    public static <T> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedure<? super T> objectIntProcedure) {
        ParallelIterate.forEachWithIndex(iterable, objectIntProcedure, EXECUTOR_SERVICE);
    }

    public static <T, BT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, BT procedure, Executor executor) {
        ParallelIterate.forEachWithIndex(iterable, new PassThruObjectIntProcedureFactory<BT>(procedure), new PassThruCombiner(), executor);
    }

    public static <T, BT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, BT procedure, int minForkSize, int taskCount) {
        ParallelIterate.forEachWithIndex(iterable, new PassThruObjectIntProcedureFactory<BT>(procedure), new PassThruCombiner(), minForkSize, taskCount);
    }

    public static <T, BT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, Executor executor) {
        int taskCount = Math.max(DEFAULT_PARALLEL_TASK_COUNT, Iterate.sizeOf(iterable) / 10000);
        ParallelIterate.forEachWithIndex(iterable, procedureFactory, combiner, 10000, taskCount, executor);
    }

    public static <T, BT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount) {
        ParallelIterate.forEachWithIndex(iterable, procedureFactory, combiner, minForkSize, taskCount, EXECUTOR_SERVICE);
    }

    public static <T, BT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount, Executor executor) {
        if (Iterate.notEmpty(iterable)) {
            if (iterable instanceof RandomAccess || iterable instanceof ListIterable && iterable instanceof List) {
                ParallelIterate.forEachWithIndexInListOnExecutor((List)iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
            } else {
                ParallelIterate.forEachWithIndexInListOnExecutor(ArrayAdapter.adapt(Iterate.toArray(iterable)), procedureFactory, combiner, minForkSize, taskCount, executor);
            }
        }
    }

    public static <T, BT extends ObjectIntProcedure<? super T>> void forEachWithIndexInListOnExecutor(List<T> list, ObjectIntProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount, Executor executor) {
        int size = list.size();
        if (size < minForkSize) {
            BT procedure = procedureFactory.create();
            Iterate.forEachWithIndex(list, procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne(procedure);
            } else {
                combiner.combineAll((Iterable<BT>)Iterables.iList(procedure));
            }
        } else {
            int threadCount = Math.min(size, taskCount);
            ObjectIntProcedureFJTaskRunner<T, BT> runner = new ObjectIntProcedureFJTaskRunner<T, BT>(combiner, threadCount);
            runner.executeAndCombine(executor, procedureFactory, list);
        }
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure) {
        ParallelIterate.forEach(iterable, procedure, EXECUTOR_SERVICE);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure, int batchSize) {
        ParallelIterate.forEach(iterable, procedure, batchSize, (Executor)EXECUTOR_SERVICE);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure, int batchSize, Executor executor) {
        ParallelIterate.forEach(iterable, procedure, batchSize, ParallelIterate.calculateTaskCount(iterable, batchSize), executor);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, BT procedure, Executor executor) {
        ParallelIterate.forEach(iterable, new PassThruProcedureFactory<BT>(procedure), new PassThruCombiner(), executor);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, BT procedure, int minForkSize, int taskCount) {
        ParallelIterate.forEach(iterable, procedure, minForkSize, taskCount, (Executor)EXECUTOR_SERVICE);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, BT procedure, int minForkSize, int taskCount, Executor executor) {
        ParallelIterate.forEach(iterable, new PassThruProcedureFactory<BT>(procedure), new PassThruCombiner(), minForkSize, taskCount, executor);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, Executor executor) {
        ParallelIterate.forEach(iterable, procedureFactory, combiner, 10000, executor);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner) {
        ParallelIterate.forEach(iterable, procedureFactory, combiner, (Executor)EXECUTOR_SERVICE);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int batchSize) {
        ParallelIterate.forEach(iterable, procedureFactory, combiner, batchSize, (Executor)EXECUTOR_SERVICE);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int batchSize, Executor executor) {
        ParallelIterate.forEach(iterable, procedureFactory, combiner, batchSize, ParallelIterate.calculateTaskCount(iterable, batchSize), executor);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount) {
        ParallelIterate.forEach(iterable, procedureFactory, combiner, minForkSize, taskCount, EXECUTOR_SERVICE);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount, Executor executor) {
        if (Iterate.notEmpty(iterable)) {
            if (iterable instanceof BatchIterable) {
                ParallelIterate.forEachInBatchWithExecutor((BatchIterable)((Object)iterable), procedureFactory, combiner, minForkSize, taskCount, executor);
            } else if ((iterable instanceof RandomAccess || iterable instanceof ListIterable) && iterable instanceof List) {
                ParallelIterate.forEachInListOnExecutor((List)iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
            } else {
                ParallelArrayIterate.forEachOn(Iterate.toArray(iterable), procedureFactory, combiner, minForkSize, taskCount, executor);
            }
        }
    }

    public static <T, BT extends Procedure<? super T>> void forEachInListOnExecutor(List<T> list, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount, Executor executor) {
        int size = list.size();
        if (size < minForkSize) {
            BT procedure = procedureFactory.create();
            Iterate.forEach(list, procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne(procedure);
            } else {
                combiner.combineAll((Iterable<BT>)Iterables.iList(procedure));
            }
        } else {
            int threadCount = Math.min(size, taskCount);
            ProcedureFJTaskRunner<T, BT> runner = new ProcedureFJTaskRunner<T, BT>(combiner, threadCount);
            runner.executeAndCombine(executor, procedureFactory, list);
        }
    }

    public static <T, BT extends Procedure<? super T>> void forEachInBatchWithExecutor(BatchIterable<T> set, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount, Executor executor) {
        int size = set.size();
        if (size < minForkSize) {
            BT procedure = procedureFactory.create();
            set.forEach((Procedure<T>)procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne(procedure);
            } else {
                combiner.combineAll((Iterable<BT>)Iterables.iList(procedure));
            }
        } else {
            int threadCount = Math.min(size, Math.min(taskCount, set.getBatchCount((int)Math.ceil((double)size / (double)taskCount))));
            BatchIterableProcedureFJTaskRunner<T, BT> runner = new BatchIterableProcedureFJTaskRunner<T, BT>(combiner, threadCount);
            runner.executeAndCombine(executor, procedureFactory, set);
        }
    }

    public static <T> Collection<T> select(Iterable<T> iterable, Predicate<? super T> predicate) {
        return ParallelIterate.select(iterable, predicate, false);
    }

    public static <T> Collection<T> select(Iterable<T> iterable, Predicate<? super T> predicate, boolean allowReorderedResult) {
        return ParallelIterate.select(iterable, predicate, null, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R select(Iterable<T> iterable, Predicate<? super T> predicate, R target, boolean allowReorderedResult) {
        return ParallelIterate.select(iterable, predicate, target, 10000, EXECUTOR_SERVICE, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R select(Iterable<T> iterable, Predicate<? super T> predicate, R target, int batchSize, Executor executor, boolean allowReorderedResult) {
        FastListSelectProcedureCombiner<T> combiner = new FastListSelectProcedureCombiner<T>(iterable, target, 10, allowReorderedResult);
        FastListSelectProcedureFactory<? super T> procedureFactory = new FastListSelectProcedureFactory<T>(predicate, batchSize);
        ParallelIterate.forEach(iterable, procedureFactory, combiner, batchSize, ParallelIterate.calculateTaskCount(iterable, batchSize), executor);
        return (R)combiner.getResult();
    }

    private static <T> int calculateTaskCount(Iterable<T> iterable, int batchSize) {
        if (iterable instanceof BatchIterable) {
            return ParallelIterate.calculateTaskCount((BatchIterable)((Object)iterable), batchSize);
        }
        return ParallelIterate.calculateTaskCount(Iterate.sizeOf(iterable), batchSize);
    }

    private static <T> int calculateTaskCount(BatchIterable<T> batchIterable, int batchSize) {
        return Math.max(2, batchIterable.getBatchCount(batchSize));
    }

    private static int calculateTaskCount(int size, int batchSize) {
        return Math.max(2, size / batchSize);
    }

    public static <T> Collection<T> reject(Iterable<T> iterable, Predicate<? super T> predicate) {
        return ParallelIterate.reject(iterable, predicate, false);
    }

    public static <T> Collection<T> reject(Iterable<T> iterable, Predicate<? super T> predicate, boolean allowReorderedResult) {
        return ParallelIterate.reject(iterable, predicate, null, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R reject(Iterable<T> iterable, Predicate<? super T> predicate, R target, boolean allowReorderedResult) {
        return ParallelIterate.reject(iterable, predicate, target, 10000, EXECUTOR_SERVICE, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R reject(Iterable<T> iterable, Predicate<? super T> predicate, R target, int batchSize, Executor executor, boolean allowReorderedResult) {
        FastListRejectProcedureCombiner<T> combiner = new FastListRejectProcedureCombiner<T>(iterable, target, 10, allowReorderedResult);
        FastListRejectProcedureFactory<? super T> procedureFactory = new FastListRejectProcedureFactory<T>(predicate, batchSize);
        ParallelIterate.forEach(iterable, procedureFactory, combiner, batchSize, ParallelIterate.calculateTaskCount(iterable, batchSize), executor);
        return (R)combiner.getResult();
    }

    public static <T> int count(Iterable<T> iterable, Predicate<? super T> predicate) {
        return ParallelIterate.count(iterable, predicate, 10000, EXECUTOR_SERVICE);
    }

    public static <T> int count(Iterable<T> iterable, Predicate<? super T> predicate, int batchSize, Executor executor) {
        CountCombiner combiner = new CountCombiner();
        CountProcedureFactory<? super T> procedureFactory = new CountProcedureFactory<T>(predicate);
        ParallelIterate.forEach(iterable, procedureFactory, combiner, batchSize, executor);
        return combiner.getCount();
    }

    public static <T, V> Collection<V> collect(Iterable<T> iterable, Function<? super T, V> function) {
        return ParallelIterate.collect(iterable, function, false);
    }

    public static <T, V> Collection<V> collect(Iterable<T> iterable, Function<? super T, V> function, boolean allowReorderedResult) {
        return ParallelIterate.collect(iterable, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collect(Iterable<T> iterable, Function<? super T, V> function, R target, boolean allowReorderedResult) {
        return ParallelIterate.collect(iterable, function, target, 10000, EXECUTOR_SERVICE, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collect(Iterable<T> iterable, Function<? super T, V> function, R target, int batchSize, Executor executor, boolean allowReorderedResult) {
        int size = Iterate.sizeOf(iterable);
        FastListCollectProcedureCombiner combiner = new FastListCollectProcedureCombiner(iterable, target, size, allowReorderedResult);
        int taskCount = ParallelIterate.calculateTaskCount(size, batchSize);
        FastListCollectProcedureFactory<? super T, V> procedureFactory = new FastListCollectProcedureFactory<T, V>(function, size / taskCount);
        ParallelIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    public static <T, V> Collection<V> flatCollect(Iterable<T> iterable, Function<? super T, Collection<V>> function) {
        return ParallelIterate.flatCollect(iterable, function, false);
    }

    public static <T, V> Collection<V> flatCollect(Iterable<T> iterable, Function<? super T, Collection<V>> function, boolean allowReorderedResult) {
        return ParallelIterate.flatCollect(iterable, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R flatCollect(Iterable<T> iterable, Function<? super T, Collection<V>> function, R target, boolean allowReorderedResult) {
        return ParallelIterate.flatCollect(iterable, function, target, 10000, EXECUTOR_SERVICE, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R flatCollect(Iterable<T> iterable, Function<? super T, Collection<V>> function, R target, int batchSize, Executor executor, boolean allowReorderedResult) {
        int size = Iterate.sizeOf(iterable);
        int taskSize = size / DEFAULT_PARALLEL_TASK_COUNT;
        FlatCollectProcedureCombiner combiner = new FlatCollectProcedureCombiner(iterable, target, size, allowReorderedResult);
        FlatCollectProcedureFactory<? super T, V> procedureFactory = new FlatCollectProcedureFactory<T, V>(function, taskSize);
        ParallelIterate.forEach(iterable, procedureFactory, combiner, batchSize, ParallelIterate.calculateTaskCount(size, batchSize), executor);
        return (R)combiner.getResult();
    }

    public static <T, V> Collection<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function) {
        return ParallelIterate.collectIf(iterable, predicate, function, false);
    }

    public static <T, V> Collection<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, boolean allowReorderedResult) {
        return ParallelIterate.collectIf(iterable, predicate, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, R target, boolean allowReorderedResult) {
        return ParallelIterate.collectIf(iterable, predicate, function, target, 10000, EXECUTOR_SERVICE, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, R target, int batchSize, Executor executor, boolean allowReorderedResult) {
        FastListCollectIfProcedureCombiner combiner = new FastListCollectIfProcedureCombiner(iterable, target, 10, allowReorderedResult);
        FastListCollectIfProcedureFactory<? super T, V> procedureFactory = new FastListCollectIfProcedureFactory<T, V>(function, predicate, batchSize);
        ParallelIterate.forEach(iterable, procedureFactory, combiner, batchSize, ParallelIterate.calculateTaskCount(iterable, batchSize), executor);
        return (R)combiner.getResult();
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function) {
        return ParallelIterate.groupBy(iterable, function, 10000, EXECUTOR_SERVICE);
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        return ParallelIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, 10000);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap) {
        return ParallelIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, mutableMap, 10000);
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, int batchSize) {
        return ParallelIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, batchSize, EXECUTOR_SERVICE);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap, int batchSize) {
        return ParallelIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, mutableMap, batchSize, EXECUTOR_SERVICE);
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, int batchSize, Executor executor) {
        return ParallelIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, ConcurrentHashMap.newMap(), batchSize, executor);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap, int batchSize, Executor executor) {
        NonMutatingAggregationProcedure<? super T, ? extends K, ? extends V> nonMutatingAggregationProcedure = new NonMutatingAggregationProcedure<T, K, V>(mutableMap, groupBy, zeroValueFactory, nonMutatingAggregator);
        ParallelIterate.forEach(iterable, new PassThruProcedureFactory<NonMutatingAggregationProcedure<? super T, ? extends K, ? extends V>>(nonMutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return mutableMap;
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        return ParallelIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, 10000);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap) {
        return ParallelIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, mutableMap, 10000);
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, int batchSize) {
        return ParallelIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, batchSize, EXECUTOR_SERVICE);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap, int batchSize) {
        return ParallelIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, mutableMap, batchSize, EXECUTOR_SERVICE);
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, int batchSize, Executor executor) {
        ConcurrentHashMap map = ConcurrentHashMap.newMap();
        MutatingAggregationProcedure<? super T, ? extends K, ? super V> mutatingAggregationProcedure = new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator);
        ParallelIterate.forEach(iterable, new PassThruProcedureFactory<MutatingAggregationProcedure<? super T, ? extends K, ? super V>>(mutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return map;
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap, int batchSize, Executor executor) {
        MutatingAggregationProcedure<? super T, ? extends K, ? super V> mutatingAggregationProcedure = new MutatingAggregationProcedure<T, K, V>(mutableMap, groupBy, zeroValueFactory, mutatingAggregator);
        ParallelIterate.forEach(iterable, new PassThruProcedureFactory<MutatingAggregationProcedure<? super T, ? extends K, ? super V>>(mutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return mutableMap;
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap) {
        return ParallelIterate.groupBy(iterable, function, concurrentMultimap, 10000);
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap, int batchSize) {
        return ParallelIterate.groupBy(iterable, function, concurrentMultimap, batchSize, EXECUTOR_SERVICE);
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, int batchSize) {
        return ParallelIterate.groupBy(iterable, function, batchSize, EXECUTOR_SERVICE);
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, int batchSize, Executor executor) {
        return ParallelIterate.groupBy(iterable, function, SynchronizedPutFastListMultimap.newMultimap(), batchSize, executor);
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap, int batchSize, Executor executor) {
        ParallelIterate.forEach(iterable, new PassThruProcedureFactory<MultimapPutProcedure<? extends K, ? super V>>(new MultimapPutProcedure<K, V>(concurrentMultimap, function)), Combiners.passThru(), batchSize, executor);
        return concurrentMultimap;
    }

    public static ExecutorService newPooledExecutor(int newPoolSize, String poolName, boolean useDaemonThreads) {
        return new ThreadPoolExecutor(newPoolSize, newPoolSize, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new CollectionsThreadFactory(poolName, useDaemonThreads), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ExecutorService newPooledExecutor(String poolName, boolean useDaemonThreads) {
        return ParallelIterate.newPooledExecutor(ParallelIterate.getDefaultMaxThreadPoolSize(), poolName, useDaemonThreads);
    }

    public static int getDefaultTaskCount() {
        return ParallelIterate.getDefaultMaxThreadPoolSize() * ParallelIterate.getTaskRatio();
    }

    public static int getDefaultMaxThreadPoolSize() {
        return Math.min(AVAILABLE_PROCESSORS + 1, 100);
    }

    public static int getTaskRatio() {
        return 2;
    }
}

