/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Service {
    public static final int RESOURCE = 0;
    public static final int CLASS = 1;
    public static final int INSTANCE = 2;
    static HashMap services = new HashMap();

    public static synchronized Iterator providerNames(Class cls) {
        return Service.providers(cls, 0);
    }

    public static synchronized Iterator providerClasses(Class cls) {
        return Service.providers(cls, false);
    }

    public static synchronized Iterator providers(Class cls) {
        return Service.providers(cls, true);
    }

    public static synchronized Iterator providers(Class cls, boolean instantiate) {
        return Service.providers(cls, instantiate ? 2 : 1);
    }

    public static synchronized Iterator providers(Class cls, int providerKind) {
        ClassLoader classLoader = cls.getClassLoader();
        String providerFile = "META-INF/services/" + cls.getName();
        ArrayList providers = (ArrayList)services.get(providerFile);
        if (providers != null) {
            return providers.iterator();
        }
        providers = new ArrayList();
        services.put(providerFile, providers);
        try {
            Enumeration<URL> providerFiles = classLoader.getResources(providerFile);
            if (providerFiles.hasMoreElements()) {
                while (providerFiles.hasMoreElements()) {
                    try {
                        URL url = providerFiles.nextElement();
                        InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
                        switch (providerKind) {
                            case 0: {
                                Service.loadResources(reader, classLoader, providers);
                                break;
                            }
                            case 1: {
                                Service.loadClasses(reader, classLoader, providers);
                                break;
                            }
                            case 2: {
                                Service.loadInstances(reader, classLoader, providers);
                            }
                        }
                    }
                    catch (Exception ex) {}
                }
            } else {
                InputStream is = classLoader.getResourceAsStream(providerFile);
                if (is == null) {
                    providerFile = providerFile.substring(providerFile.lastIndexOf(46) + 1);
                    is = classLoader.getResourceAsStream(providerFile);
                }
                if (is != null) {
                    InputStreamReader reader = new InputStreamReader(is, "UTF-8");
                    Service.loadInstances(reader, classLoader, providers);
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return providers.iterator();
    }

    private static void loadResources(Reader input, ClassLoader classLoader, List providers) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        String line = reader.readLine();
        while (line != null) {
            providers.add(line);
            line = reader.readLine();
        }
    }

    private static void loadClasses(Reader input, ClassLoader classLoader, List classes) throws IOException {
        for (String className : Service.readLines(input)) {
            try {
                classes.add(classLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {}
        }
    }

    private static void loadInstances(Reader input, ClassLoader classLoader, List providers) throws IOException {
        for (String className : Service.readLines(input)) {
            int modifierIndex = className.indexOf(95);
            String modifier = null;
            if (modifierIndex != -1) {
                modifier = className.substring(modifierIndex + 1);
                className = className.substring(0, modifierIndex);
            }
            try {
                Class<?> klass = classLoader.loadClass(className);
                Object obj = klass.newInstance();
                if (null != modifier) {
                    Method setModifierMethod = klass.getMethod("setModifier", String.class);
                    setModifierMethod.invoke(obj, modifier);
                }
                providers.add(obj);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static List readLines(Reader input) throws IOException {
        String line;
        ArrayList<String> linesList = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(input);
        while ((line = reader.readLine()) != null) {
            try {
                int idx = line.indexOf(35);
                if (idx != -1) {
                    line = line.substring(0, idx);
                }
                if ((line = line.trim()).length() <= 0) continue;
                linesList.add(line);
            }
            catch (Exception ex) {}
        }
        return linesList;
    }
}

