/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.gentyref;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeToken<T> {
    private final Type type;

    protected TypeToken() {
        this.type = this.extractType();
    }

    private TypeToken(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    private Type extractType() {
        Type t = this.getClass().getGenericSuperclass();
        if (!(t instanceof ParameterizedType)) {
            throw new RuntimeException("Invalid TypeToken; must specify type parameters");
        }
        ParameterizedType pt = (ParameterizedType)t;
        if (pt.getRawType() != TypeToken.class) {
            throw new RuntimeException("Invalid TypeToken; must directly extend TypeToken");
        }
        return pt.getActualTypeArguments()[0];
    }

    public static <T> TypeToken<T> get(Class<T> type) {
        return new SimpleTypeToken(type);
    }

    public static TypeToken<?> get(Type type) {
        return new SimpleTypeToken(type);
    }

    public boolean equals(Object obj) {
        return obj instanceof TypeToken && this.type.equals(((TypeToken)obj).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    private static class SimpleTypeToken<T>
    extends TypeToken<T> {
        public SimpleTypeToken(Type type) {
            super(type);
        }
    }
}

