/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.report.log;

import java.util.List;
import java.util.Map;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.IFunction;

class ReportLogMerger {
    ReportLogMerger() {
    }

    public <T> T merge(T obj, T update) {
        if (obj instanceof Map) {
            return (T)this.mergeMap((Map)obj, (Map)update);
        }
        if (obj instanceof List) {
            return (T)this.mergeList((List)obj, (List)update);
        }
        return update;
    }

    public Map<String, Object> mergeMap(Map<String, Object> map, Map<String, Object> update) {
        if (map == null) {
            return update;
        }
        for (Map.Entry<String, Object> entry : update.entrySet()) {
            map.put(entry.getKey(), this.merge(map.get(entry.getKey()), entry.getValue()));
        }
        return map;
    }

    public List<Object> mergeList(List<Object> list, List<Object> update) {
        if (list == null) {
            return update;
        }
        if (this.isNameIndexed(list)) {
            return this.mergeNameIndexed(list, update);
        }
        list.addAll(update);
        return list;
    }

    private boolean isNameIndexed(List<Object> list) {
        return !list.isEmpty() && list.get(0) instanceof Map && ((Map)list.get(0)).containsKey("name");
    }

    private List mergeNameIndexed(List<Map<String, Object>> list, List<Map<String, Object>> update) {
        for (final Map<String, Object> fromElem : update) {
            int index = CollectionUtil.findIndexOf(list, new IFunction<Map<String, Object>, Boolean>(){

                @Override
                public Boolean apply(Map<String, Object> map) {
                    return map.get("name").equals(fromElem.get("name"));
                }
            });
            if (index != -1) {
                list.set(index, this.mergeMap(list.get(index), fromElem));
                continue;
            }
            list.add(fromElem);
        }
        return list;
    }
}

