/*
 * Decompiled with CFR 0.152.
 */
package spock.util.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import spock.util.concurrent.BlockingVariable;

class BlockingVariablesImpl {
    private final double timeout;
    private final ConcurrentHashMap<String, BlockingVariable<Object>> map = new ConcurrentHashMap();

    public BlockingVariablesImpl(double timeout) {
        this.timeout = timeout;
    }

    public Object get(String name) throws InterruptedException {
        BlockingVariable entry = new BlockingVariable(this.timeout);
        BlockingVariable oldEntry = this.map.putIfAbsent(name, entry);
        if (oldEntry == null) {
            return entry.get();
        }
        return oldEntry.get();
    }

    public void put(String name, Object value) {
        BlockingVariable<Object> entry = new BlockingVariable<Object>(this.timeout);
        BlockingVariable<Object> oldEntry = this.map.putIfAbsent(name, entry);
        if (oldEntry == null) {
            entry.set(value);
        } else {
            oldEntry.set(value);
        }
    }
}

